/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.loader.java;

import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.k.RoutesLoader;
import org.apache.camel.k.Source;
import org.apache.commons.lang3.StringUtils;

public class JavaClassRoutesLoader
implements RoutesLoader {
    public List<String> getSupportedLanguages() {
        return Collections.singletonList("class");
    }

    public RouteBuilder load(CamelContext camelContext, Source source) throws Exception {
        String name = source.getName();
        Class<?> type = Class.forName(name = StringUtils.removeEnd((String)name, (String)".class"));
        if (!RouteBuilder.class.isAssignableFrom(type)) {
            throw new IllegalStateException("The class provided (" + source.getLocation() + ") is not a org.apache.camel.builder.RouteBuilder");
        }
        return (RouteBuilder)type.newInstance();
    }
}

