/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.loader.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.k.CompositeClassloader;
import org.apache.camel.k.Source;
import org.apache.camel.k.SourceLoader;
import org.apache.camel.k.support.StringSupport;
import org.apache.camel.util.IOHelper;
import org.joor.Reflect;

public class JavaSourceLoader
implements SourceLoader {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+([a-zA-Z][\\.\\w]*)\\s*;.*$", 8);

    public Collection<String> getSupportedLanguages() {
        return Collections.singletonList("java");
    }

    public RoutesBuilder load(CamelContext camelContext, Source source) {
        RoutesBuilder routesBuilder;
        block9: {
            InputStream is = source.resolveAsInputStream(camelContext);
            try {
                String content = IOHelper.loadText((InputStream)is);
                String name = JavaSourceLoader.determineQualifiedName(source, content);
                Reflect compiled = Reflect.compile((String)name, (String)content);
                RoutesBuilder instance = (RoutesBuilder)compiled.create().get();
                ClassLoader loader = camelContext.getApplicationContextClassLoader();
                if (loader instanceof CompositeClassloader) {
                    ((CompositeClassloader)loader).addClassLoader(instance.getClass().getClassLoader());
                }
                routesBuilder = instance;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return routesBuilder;
    }

    private static String determineQualifiedName(Source source, String content) {
        String name = StringSupport.substringBefore((String)source.getName(), (String)".java");
        Matcher matcher = PACKAGE_PATTERN.matcher(content);
        return matcher.find() ? matcher.group(1) + "." + name : name;
    }
}

