/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.quarkus.it.knative.source;

import io.quarkus.arc.Unremovable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.ToDefinition;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/test")
@ApplicationScoped
public class KnativeSourceApplication {
    @Inject
    CamelContext context;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

    @POST
    @Path(value="/toUpper")
    @javax.ws.rs.Produces(value={"text/plain"})
    public void toUpper(String data) throws InterruptedException {
        this.queue.put(data.toUpperCase(Locale.US));
    }

    @GET
    @Path(value="/inspect/endpoint-uris")
    @javax.ws.rs.Produces(value={"application/json"})
    public JsonArray endpointUris() {
        List definitions = ((ModelCamelContext)this.context.adapt(ModelCamelContext.class)).getRouteDefinitions();
        return Json.createArrayBuilder((Collection)definitions.stream().map(d -> !d.getOutputs().isEmpty() ? (ProcessorDefinition)d.getOutputs().get(d.getOutputs().size() - 1) : null).filter(Objects::nonNull).filter(ToDefinition.class::isInstance).map(ToDefinition.class::cast).map(SendDefinition::getEndpointUri).collect(Collectors.toList())).build();
    }

    @POST
    @Path(value="/send")
    @javax.ws.rs.Produces(value={"text/plain"})
    public void send(String data) throws IOException {
        try (FluentProducerTemplate template = this.context.createFluentProducerTemplate();){
            template.to("direct:start").withHeader("MyHeader", (Object)data).send();
        }
    }

    @GET
    @Path(value="/poll")
    @javax.ws.rs.Produces(value={"text/plain"})
    public Response poll() {
        String result = (String)this.queue.poll();
        return result != null ? Response.ok((Object)result).build() : Response.noContent().build();
    }

    @Unremovable
    @Produces
    KnativeEnvironment environment(@ConfigProperty(name="kamel.k.sink.port") int port) {
        return KnativeEnvironment.on((KnativeResource[])new KnativeResource[]{KnativeEnvironment.serviceBuilder((Knative.Type)Knative.Type.endpoint, (String)"sink").withUrl("http://localhost:" + port + "/test/toUpper").withEndpointKind(Knative.EndpointKind.sink).build()});
    }
}

