/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.quarkus.it;

import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.bind.JsonbBuilder;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.component.knative.KnativeEndpoint;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@RegisterForReflection(targets={String.class})
@Path(value="/test")
@ApplicationScoped
public class KnativeEnvFromRegistryApplication {
    @Inject
    CamelContext context;
    @Inject
    FluentProducerTemplate template;

    @GET
    @Path(value="/inspect")
    @Produces(value={"application/json"})
    public String inspect() {
        return ((KnativeEndpoint)this.context.getEndpoint("knative:endpoint/from", KnativeEndpoint.class)).getConfiguration().getEnvironment().lookup(Knative.Type.endpoint, "from").filter(entry -> Objects.equals(Knative.EndpointKind.source, entry.getEndpointKind())).findFirst().map(def -> JsonbBuilder.create().toJson(def)).orElseThrow(IllegalArgumentException::new);
    }

    @POST
    @Path(value="/execute")
    @Produces(value={"text/plain"})
    public String execute(String payload) {
        return (String)this.template.to("direct:process").withBody((Object)payload).request(String.class);
    }

    @jakarta.enterprise.inject.Produces
    KnativeEnvironment environment(@ConfigProperty(name="camel.knative.listening.port") int port) {
        return KnativeEnvironment.on((KnativeResource[])new KnativeResource[]{KnativeEnvironment.serviceBuilder((Knative.Type)Knative.Type.endpoint, (String)"process").withEndpointKind(Knative.EndpointKind.source).withMeta("service.path", "/knative").build(), KnativeEnvironment.serviceBuilder((Knative.Type)Knative.Type.endpoint, (String)"from").withEndpointKind(Knative.EndpointKind.source).withMeta("service.path", "/knative").withMeta("knative.event.type", "camel.k.evt").build(), KnativeEnvironment.serviceBuilder((Knative.Type)Knative.Type.endpoint, (String)"process").withEndpointKind(Knative.EndpointKind.sink).withMeta("service.url", String.format("http://localhost:%d/knative", port)).build()});
    }
}

