/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.quarkus.it;

import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.json.bind.JsonbBuilder;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.component.knative.KnativeEndpoint;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@RegisterForReflection(targets={String.class})
@Path(value="/test")
@ApplicationScoped
public class KnativeEnvFromRegistryApplication {
    @Inject
    CamelContext context;
    @Inject
    FluentProducerTemplate template;

    @GET
    @Path(value="/inspect")
    @javax.ws.rs.Produces(value={"application/json"})
    public String inspect() {
        return ((KnativeEndpoint)this.context.getEndpoint("knative:endpoint/from", KnativeEndpoint.class)).getConfiguration().getEnvironment().lookup(Knative.Type.endpoint, "from").filter(entry -> Objects.equals(Knative.EndpointKind.source, entry.getEndpointKind())).findFirst().map(def -> JsonbBuilder.create().toJson(def)).orElseThrow(IllegalArgumentException::new);
    }

    @POST
    @Path(value="/execute")
    @javax.ws.rs.Produces(value={"text/plain"})
    public String execute(String payload) {
        return (String)this.template.to("direct:process").withBody((Object)payload).request(String.class);
    }

    @Produces
    KnativeEnvironment environment(@ConfigProperty(name="camel.knative.listening.port") int port) {
        return KnativeEnvironment.on((KnativeResource[])new KnativeResource[]{KnativeEnvironment.serviceBuilder((Knative.Type)Knative.Type.endpoint, (String)"process").withEndpointKind(Knative.EndpointKind.source).withMeta("service.path", "/knative").build(), KnativeEnvironment.serviceBuilder((Knative.Type)Knative.Type.endpoint, (String)"from").withEndpointKind(Knative.EndpointKind.source).withMeta("service.path", "/knative").withMeta("knative.event.type", "camel.k.evt").build(), KnativeEnvironment.serviceBuilder((Knative.Type)Knative.Type.endpoint, (String)"process").withEndpointKind(Knative.EndpointKind.sink).withMeta("service.url", String.format("http://localhost:%d/knative", port)).build()});
    }
}

