package org.apache.camel.v1.integrationprofilespec;

import org.apache.camel.v1.integrationprofilespec.build.Maven;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import org.apache.camel.v1.integrationprofilespec.build.Registry;
import org.apache.camel.v1.integrationprofilespec.build.MavenFluent;
import org.apache.camel.v1.integrationprofilespec.build.RegistryFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import org.apache.camel.v1.integrationprofilespec.build.RegistryBuilder;
import org.apache.camel.v1.integrationprofilespec.build.MavenBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildFluent<A extends BuildFluent<A>> extends BaseFluent<A>{
  public BuildFluent() {
  }
  
  public BuildFluent(Build instance) {
    this.copyInstance(instance);
  }
  private String baseImage;
  private MavenBuilder maven;
  private RegistryBuilder registry;
  private String runtimeProvider;
  private String runtimeVersion;
  private String timeout;
  
  protected void copyInstance(Build instance) {
    instance = (instance != null ? instance : new Build());
    if (instance != null) {
          this.withBaseImage(instance.getBaseImage());
          this.withMaven(instance.getMaven());
          this.withRegistry(instance.getRegistry());
          this.withRuntimeProvider(instance.getRuntimeProvider());
          this.withRuntimeVersion(instance.getRuntimeVersion());
          this.withTimeout(instance.getTimeout());
        }
  }
  
  public String getBaseImage() {
    return this.baseImage;
  }
  
  public A withBaseImage(String baseImage) {
    this.baseImage = baseImage;
    return (A) this;
  }
  
  public boolean hasBaseImage() {
    return this.baseImage != null;
  }
  
  public Maven buildMaven() {
    return this.maven != null ? this.maven.build() : null;
  }
  
  public A withMaven(Maven maven) {
    this._visitables.remove("maven");
    if (maven != null) {
        this.maven = new MavenBuilder(maven);
        this._visitables.get("maven").add(this.maven);
    } else {
        this.maven = null;
        this._visitables.get("maven").remove(this.maven);
    }
    return (A) this;
  }
  
  public boolean hasMaven() {
    return this.maven != null;
  }
  
  public MavenNested<A> withNewMaven() {
    return new MavenNested(null);
  }
  
  public MavenNested<A> withNewMavenLike(Maven item) {
    return new MavenNested(item);
  }
  
  public MavenNested<A> editBuildMaven() {
    return withNewMavenLike(java.util.Optional.ofNullable(buildMaven()).orElse(null));
  }
  
  public MavenNested<A> editOrNewMaven() {
    return withNewMavenLike(java.util.Optional.ofNullable(buildMaven()).orElse(new MavenBuilder().build()));
  }
  
  public MavenNested<A> editOrNewMavenLike(Maven item) {
    return withNewMavenLike(java.util.Optional.ofNullable(buildMaven()).orElse(item));
  }
  
  public Registry buildRegistry() {
    return this.registry != null ? this.registry.build() : null;
  }
  
  public A withRegistry(Registry registry) {
    this._visitables.remove("registry");
    if (registry != null) {
        this.registry = new RegistryBuilder(registry);
        this._visitables.get("registry").add(this.registry);
    } else {
        this.registry = null;
        this._visitables.get("registry").remove(this.registry);
    }
    return (A) this;
  }
  
  public boolean hasRegistry() {
    return this.registry != null;
  }
  
  public RegistryNested<A> withNewRegistry() {
    return new RegistryNested(null);
  }
  
  public RegistryNested<A> withNewRegistryLike(Registry item) {
    return new RegistryNested(item);
  }
  
  public RegistryNested<A> editBuildRegistry() {
    return withNewRegistryLike(java.util.Optional.ofNullable(buildRegistry()).orElse(null));
  }
  
  public RegistryNested<A> editOrNewRegistry() {
    return withNewRegistryLike(java.util.Optional.ofNullable(buildRegistry()).orElse(new RegistryBuilder().build()));
  }
  
  public RegistryNested<A> editOrNewRegistryLike(Registry item) {
    return withNewRegistryLike(java.util.Optional.ofNullable(buildRegistry()).orElse(item));
  }
  
  public String getRuntimeProvider() {
    return this.runtimeProvider;
  }
  
  public A withRuntimeProvider(String runtimeProvider) {
    this.runtimeProvider = runtimeProvider;
    return (A) this;
  }
  
  public boolean hasRuntimeProvider() {
    return this.runtimeProvider != null;
  }
  
  public String getRuntimeVersion() {
    return this.runtimeVersion;
  }
  
  public A withRuntimeVersion(String runtimeVersion) {
    this.runtimeVersion = runtimeVersion;
    return (A) this;
  }
  
  public boolean hasRuntimeVersion() {
    return this.runtimeVersion != null;
  }
  
  public String getTimeout() {
    return this.timeout;
  }
  
  public A withTimeout(String timeout) {
    this.timeout = timeout;
    return (A) this;
  }
  
  public boolean hasTimeout() {
    return this.timeout != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildFluent that = (BuildFluent) o;
    if (!java.util.Objects.equals(baseImage, that.baseImage)) return false;
    if (!java.util.Objects.equals(maven, that.maven)) return false;
    if (!java.util.Objects.equals(registry, that.registry)) return false;
    if (!java.util.Objects.equals(runtimeProvider, that.runtimeProvider)) return false;
    if (!java.util.Objects.equals(runtimeVersion, that.runtimeVersion)) return false;
    if (!java.util.Objects.equals(timeout, that.timeout)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(baseImage,  maven,  registry,  runtimeProvider,  runtimeVersion,  timeout,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (maven != null) { sb.append("maven:"); sb.append(maven + ","); }
    if (registry != null) { sb.append("registry:"); sb.append(registry + ","); }
    if (runtimeProvider != null) { sb.append("runtimeProvider:"); sb.append(runtimeProvider + ","); }
    if (runtimeVersion != null) { sb.append("runtimeVersion:"); sb.append(runtimeVersion + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout); }
    sb.append("}");
    return sb.toString();
  }
  public class MavenNested<N> extends MavenFluent<MavenNested<N>> implements Nested<N>{
    MavenNested(Maven item) {
      this.builder = new MavenBuilder(this, item);
    }
    MavenBuilder builder;
    
    public N and() {
      return (N) BuildFluent.this.withMaven(builder.build());
    }
    
    public N endBuildMaven() {
      return and();
    }
    
  
  }
  public class RegistryNested<N> extends RegistryFluent<RegistryNested<N>> implements Nested<N>{
    RegistryNested(Registry item) {
      this.builder = new RegistryBuilder(this, item);
    }
    RegistryBuilder builder;
    
    public N and() {
      return (N) BuildFluent.this.withRegistry(builder.build());
    }
    
    public N endBuildRegistry() {
      return and();
    }
    
  
  }

}