package org.apache.camel.v1.buildspec.tasks.package_.runtime.capabilities;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RuntimePropertiesBuilder extends RuntimePropertiesFluent<RuntimePropertiesBuilder> implements VisitableBuilder<RuntimeProperties,RuntimePropertiesBuilder>{
  public RuntimePropertiesBuilder() {
    this(new RuntimeProperties());
  }
  
  public RuntimePropertiesBuilder(RuntimePropertiesFluent<?> fluent) {
    this(fluent, new RuntimeProperties());
  }
  
  public RuntimePropertiesBuilder(RuntimePropertiesFluent<?> fluent,RuntimeProperties instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RuntimePropertiesBuilder(RuntimeProperties instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RuntimePropertiesFluent<?> fluent;
  
  public RuntimeProperties build() {
    RuntimeProperties buildable = new RuntimeProperties();
    buildable.setKey(fluent.getKey());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  

}