package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IntegrationProfileBuilder extends IntegrationProfileFluent<IntegrationProfileBuilder> implements VisitableBuilder<IntegrationProfile,IntegrationProfileBuilder>{
  public IntegrationProfileBuilder() {
    this(new IntegrationProfile());
  }
  
  public IntegrationProfileBuilder(IntegrationProfileFluent<?> fluent) {
    this(fluent, new IntegrationProfile());
  }
  
  public IntegrationProfileBuilder(IntegrationProfileFluent<?> fluent,IntegrationProfile instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IntegrationProfileBuilder(IntegrationProfile instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IntegrationProfileFluent<?> fluent;
  
  public IntegrationProfile build() {
    IntegrationProfile buildable = new IntegrationProfile();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setSpec(fluent.buildSpec());
    buildable.setStatus(fluent.buildStatus());
    buildable.setKind(fluent.getKind());
    buildable.setApiVersion(fluent.getApiVersion());
    return buildable;
  }
  

}