/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.apt;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.k.annotation.Loader;
import org.apache.camel.k.annotation.yaml.YAMLStepParser;

@SupportedAnnotationTypes(value={"org.apache.camel.k.annotation.Loader", "org.apache.camel.k.annotation.yaml.YAMLStepParser"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CamelProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> ae = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : ae) {
                this.on(element, Loader.class, (e, a) -> {
                    for (String loader : a.value()) {
                        this.service(this.output("META-INF/services/org/apache/camel/k/loader/%s", loader), (TypeElement)e);
                    }
                });
                this.on(element, YAMLStepParser.class, (e, a) -> {
                    for (String id : a.value()) {
                        this.service(this.output("META-INF/services/org/apache/camel/k/loader/yaml-parser/%s", id), (TypeElement)e);
                    }
                });
            }
        }
        return false;
    }

    private Path output(String fmt, Object ... args) {
        try {
            FileObject result;
            try {
                result = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", String.format(fmt, args));
            }
            catch (IOException e) {
                result = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", String.format(fmt, args), new Element[0]);
            }
            Path answer = Paths.get(result.toUri());
            if (!Files.exists(answer.getParent(), new LinkOption[0])) {
                Files.createDirectories(answer.getParent(), new FileAttribute[0]);
            }
            return answer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void service(Path target, String type) {
        try {
            Files.write(target, String.format("class=%s", type).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void service(Path target, TypeElement type) {
        this.service(target, type.getQualifiedName().toString());
    }

    private <T extends Annotation> void on(Element element, Class<T> annotationType, BiConsumer<TypeElement, T> consumer) {
        T annotation;
        if (element instanceof TypeElement && (annotation = element.getAnnotation(annotationType)) != null) {
            consumer.accept((TypeElement)element, (TypeElement)annotation);
        }
    }
}

