/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.camel.component.linkedin.api.OAuthParams;
import org.apache.camel.component.linkedin.api.OAuthScope;
import org.apache.camel.component.linkedin.api.OAuthSecureStorage;
import org.apache.camel.component.linkedin.api.OAuthToken;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public final class LinkedInOAuthRequestFilter
implements ClientRequestFilter {
    public static final String BASE_ADDRESS = "https://api.linkedin.com/v1";
    private static final Logger LOG = LoggerFactory.getLogger(LinkedInOAuthRequestFilter.class);
    private static final String AUTHORIZATION_URL = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=%s&state=%s&redirect_uri=%s";
    private static final String AUTHORIZATION_URL_WITH_SCOPE = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=%s&state=%s&scope=%s&redirect_uri=%s";
    private static final String ACCESS_TOKEN_URL = "https://www.linkedin.com/uas/oauth2/accessToken?grant_type=authorization_code&code=%s&redirect_uri=%s&client_id=%s&client_secret=%s";
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("&?([^=]+)=([^&]+)");
    private final WebClient webClient;
    private final OAuthParams oAuthParams;
    private OAuthToken oAuthToken;

    public LinkedInOAuthRequestFilter(OAuthParams oAuthParams, Map<String, Object> httpParams, boolean lazyAuth, String[] enabledProtocols) {
        this.oAuthParams = oAuthParams;
        this.oAuthToken = null;
        this.webClient = new WebClient(BrowserVersion.FIREFOX_24);
        WebClientOptions options = this.webClient.getOptions();
        options.setRedirectEnabled(true);
        options.setJavaScriptEnabled(false);
        options.setThrowExceptionOnFailingStatusCode(true);
        options.setThrowExceptionOnScriptError(true);
        options.setPrintContentOnFailingStatusCode(LOG.isDebugEnabled());
        options.setSSLClientProtocols(enabledProtocols);
        if (httpParams != null && httpParams.get("http.route.default-proxy") != null) {
            HttpHost proxyHost = (HttpHost)httpParams.get("http.route.default-proxy");
            Boolean socksProxy = (Boolean)httpParams.get("http.route.socks-proxy");
            ProxyConfig proxyConfig = new ProxyConfig(proxyHost.getHostName(), proxyHost.getPort(), socksProxy != null ? socksProxy : false);
            options.setProxyConfig(proxyConfig);
        }
        new WebConnectionWrapper(this.webClient){

            public WebResponse getResponse(WebRequest request) throws IOException {
                request.setAdditionalHeader("Accept-Encoding", "identity");
                return super.getResponse(request);
            }
        };
        if (!lazyAuth) {
            try {
                this.updateOAuthToken();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Error authorizing user %s: %s", oAuthParams.getUserName(), e.getMessage()), e);
            }
        }
    }

    private String getRefreshToken() {
        this.webClient.getOptions().setRedirectEnabled(true);
        try {
            String redirectQuery;
            String url;
            String csrfId = String.valueOf(new SecureRandom().nextLong());
            String encodedRedirectUri = URLEncoder.encode(this.oAuthParams.getRedirectUri(), "UTF-8");
            OAuthScope[] scopes = this.oAuthParams.getScopes();
            if (scopes == null || scopes.length == 0) {
                url = String.format(AUTHORIZATION_URL, this.oAuthParams.getClientId(), csrfId, encodedRedirectUri);
            } else {
                int nScopes = scopes.length;
                StringBuilder builder = new StringBuilder();
                int i = 0;
                for (OAuthScope scope : scopes) {
                    builder.append(scope.getValue());
                    if (++i >= nScopes) continue;
                    builder.append("%20");
                }
                url = String.format(AUTHORIZATION_URL_WITH_SCOPE, this.oAuthParams.getClientId(), csrfId, builder.toString(), encodedRedirectUri);
            }
            HtmlPage authPage = (HtmlPage)this.webClient.getPage(url);
            HtmlDivision div = (HtmlDivision)authPage.getFirstByXPath("//div[@role='alert']");
            if (div != null) {
                throw new IllegalArgumentException("Error authorizing application: " + div.getTextContent());
            }
            HtmlForm loginForm = authPage.getFormByName("oauth2SAuthorizeForm");
            HtmlTextInput login = (HtmlTextInput)loginForm.getInputByName("session_key");
            login.setText(this.oAuthParams.getUserName());
            HtmlPasswordInput password = (HtmlPasswordInput)loginForm.getInputByName("session_password");
            password.setText(this.oAuthParams.getUserPassword());
            HtmlSubmitInput submitInput = (HtmlSubmitInput)loginForm.getInputByName("authorize");
            this.webClient.getOptions().setRedirectEnabled(false);
            try {
                Page redirectPage = submitInput.click();
                redirectQuery = redirectPage.getUrl().getQuery();
            }
            catch (FailingHttpStatusCodeException e) {
                if (e.getStatusCode() != 302) {
                    throw e;
                }
                String location = e.getResponse().getResponseHeaderValue("Location");
                redirectQuery = location.substring(location.indexOf(63) + 1);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Matcher matcher = QUERY_PARAM_PATTERN.matcher(redirectQuery);
            while (matcher.find()) {
                params.put(matcher.group(1), matcher.group(2));
            }
            String state = (String)params.get("state");
            if (!csrfId.equals(state)) {
                throw new SecurityException("Invalid CSRF code!");
            }
            return (String)params.get("code");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error authorizing application: " + e.getMessage(), e);
        }
    }

    public void close() {
        this.webClient.closeAllWindows();
    }

    private OAuthToken getAccessToken(String refreshToken) throws IOException {
        String tokenUrl = String.format(ACCESS_TOKEN_URL, refreshToken, this.oAuthParams.getRedirectUri(), this.oAuthParams.getClientId(), this.oAuthParams.getClientSecret());
        WebRequest webRequest = new WebRequest(new URL(tokenUrl), HttpMethod.POST);
        WebResponse webResponse = this.webClient.loadWebResponse(webRequest);
        if (webResponse.getStatusCode() != 200) {
            throw new IOException(String.format("Error getting access token: [%s: %s]", webResponse.getStatusCode(), webResponse.getStatusMessage()));
        }
        long currentTime = System.currentTimeMillis();
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(webResponse.getContentAsStream(), Map.class);
        String accessToken = map.get("access_token").toString();
        Integer expiresIn = Integer.valueOf(map.get("expires_in").toString());
        return new OAuthToken(refreshToken, accessToken, currentTime + TimeUnit.MILLISECONDS.convert(expiresIn.intValue(), TimeUnit.SECONDS));
    }

    public synchronized OAuthToken getOAuthToken() {
        return this.oAuthToken;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        this.updateOAuthToken();
        String requestUri = requestContext.getUri().toString();
        StringBuilder builder = new StringBuilder(requestUri);
        if (requestUri.contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        builder.append("oauth2_access_token=").append(this.oAuthToken.getAccessToken());
        requestContext.setUri(URI.create(builder.toString()));
    }

    private synchronized void updateOAuthToken() throws IOException {
        long currentTime = System.currentTimeMillis();
        if (this.oAuthToken == null || this.oAuthToken.getExpiryTime() < currentTime) {
            LOG.info("OAuth token doesn't exist or has expired");
            OAuthSecureStorage secureStorage = this.oAuthParams.getSecureStorage();
            if (secureStorage != null) {
                this.oAuthToken = secureStorage.getOAuthToken();
                if (this.oAuthToken != null && this.oAuthToken.getExpiryTime() > currentTime) {
                    return;
                }
                LOG.info("OAuth secure storage returned a null or expired token, creating a new token...");
                if (this.oAuthParams.getUserPassword() == null || this.oAuthParams.getUserPassword().isEmpty()) {
                    throw new IllegalArgumentException("Missing password for LinkedIn authorization");
                }
            }
            String refreshToken = this.getRefreshToken();
            this.oAuthToken = this.getAccessToken(refreshToken);
            LOG.info("OAuth token created!");
            if (secureStorage != null) {
                secureStorage.saveOAuthToken(this.oAuthToken);
            }
        }
    }
}

