/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.component.linkedin.api.Category;
import org.apache.camel.component.linkedin.api.Order;
import org.apache.camel.component.linkedin.api.Role;
import org.apache.camel.component.linkedin.api.Type;
import org.apache.camel.component.linkedin.api.model.Activity;
import org.apache.camel.component.linkedin.api.model.Comments;
import org.apache.camel.component.linkedin.api.model.Companies;
import org.apache.camel.component.linkedin.api.model.Company;
import org.apache.camel.component.linkedin.api.model.Connections;
import org.apache.camel.component.linkedin.api.model.GroupMembership;
import org.apache.camel.component.linkedin.api.model.GroupMemberships;
import org.apache.camel.component.linkedin.api.model.Groups;
import org.apache.camel.component.linkedin.api.model.IsLiked;
import org.apache.camel.component.linkedin.api.model.JobBookmark;
import org.apache.camel.component.linkedin.api.model.JobBookmarks;
import org.apache.camel.component.linkedin.api.model.JobSuggestions;
import org.apache.camel.component.linkedin.api.model.Likes;
import org.apache.camel.component.linkedin.api.model.MailboxItem;
import org.apache.camel.component.linkedin.api.model.MembershipState;
import org.apache.camel.component.linkedin.api.model.NetworkStats;
import org.apache.camel.component.linkedin.api.model.Person;
import org.apache.camel.component.linkedin.api.model.Posts;
import org.apache.camel.component.linkedin.api.model.Share;
import org.apache.camel.component.linkedin.api.model.Update;
import org.apache.camel.component.linkedin.api.model.UpdateComment;
import org.apache.camel.component.linkedin.api.model.Updates;

@Path(value="people")
public interface PeopleResource {
    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~{fields}")
    public Person getPerson(@PathParam(value="fields") String var1, @QueryParam(value="secure-urls") Boolean var2);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/connections{fields}")
    public Connections getConnections(@PathParam(value="fields") String var1, @QueryParam(value="secure-urls") Boolean var2);

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/~/shares")
    public Update share(Share var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/network/updates{fields}")
    public Updates getNetworkUpdates(@QueryParam(value="scope") String var1, @QueryParam(value="type") Type var2, @QueryParam(value="count") Long var3, @QueryParam(value="start") Long var4, @QueryParam(value="after") Long var5, @QueryParam(value="before") Long var6, @QueryParam(value="show-hidden-members") Boolean var7, @PathParam(value="fields") String var8, @QueryParam(value="secure-urls") Boolean var9);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/network/updates/key={update-key}/update-comments{fields}")
    public Comments getUpdateComments(@PathParam(value="update-key") String var1, @PathParam(value="fields") String var2, @QueryParam(value="secure-urls") Boolean var3);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/~/network/updates/key={update-key}/update-comments")
    public void addUpdateComment(@PathParam(value="update-key") String var1, UpdateComment var2);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/network/updates/key={update-key}/likes{fields}")
    public Likes getUpdateLikes(@PathParam(value="update-key") String var1, @PathParam(value="fields") String var2, @QueryParam(value="secure-urls") Boolean var3);

    @PUT
    @Consumes(value={"application/xml"})
    @Path(value="/~/network/updates/key={update-key}/is-liked")
    public void likeUpdate(@PathParam(value="update-key") String var1, IsLiked var2);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/network/network-stats")
    public NetworkStats getNetworkStats();

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/~/person-activities")
    public void addActivity(Activity var1);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/~/mailbox")
    public void addInvite(MailboxItem var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/group-memberships{fields}")
    public GroupMemberships getGroupMemberships(@QueryParam(value="membership-state") MembershipState var1, @PathParam(value="fields") String var2, @QueryParam(value="count") Long var3, @QueryParam(value="start") Long var4);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/~/group-memberships")
    public void addGroupMembership(GroupMembership var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/group-memberships/{group-id}{fields}")
    public GroupMemberships getGroupMembershipSettings(@PathParam(value="group-id") long var1, @PathParam(value="fields") String var3, @QueryParam(value="count") Long var4, @QueryParam(value="start") Long var5);

    @PUT
    @Consumes(value={"application/xml"})
    @Path(value="/~/group-memberships/{group-id}")
    public void updateGroupMembership(@PathParam(value="group-id") long var1, GroupMembership var3);

    @DELETE
    @Path(value="/~/group-memberships/{group-id}")
    public void removeGroupMembership(@PathParam(value="group-id") long var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/group-memberships/{group-id}/posts{fields}")
    public Posts getPosts(@PathParam(value="group-id") long var1, @QueryParam(value="start") Long var3, @QueryParam(value="count") Long var4, @QueryParam(value="order") Order var5, @QueryParam(value="role") Role var6, @QueryParam(value="category") Category var7, @QueryParam(value="modified-since") Long var8, @PathParam(value="fields") String var9);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/job-bookmarks")
    public JobBookmarks getJobBookmarks();

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/~/job-bookmarks")
    public void addJobBookmark(JobBookmark var1);

    @DELETE
    @Path(value="/~/job-bookmarks/{job-id}")
    public void removeJobBookmark(@PathParam(value="job-id") long var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/suggestions/groups{fields}")
    public Groups getSuggestedGroups(@PathParam(value="fields") String var1);

    @DELETE
    @Path(value="/~/suggestions/groups/{group-id}")
    public void removeGroupSuggestion(@PathParam(value="group-id") long var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/suggestions/groups/{group-id}/posts{fields}")
    public Posts getSuggestedGroupPosts(@PathParam(value="group-id") long var1, @QueryParam(value="start") Long var3, @QueryParam(value="count") Long var4, @QueryParam(value="order") Order var5, @QueryParam(value="role") Role var6, @QueryParam(value="category") Category var7, @QueryParam(value="modified-since") Long var8, @PathParam(value="fields") String var9);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/suggestions/to-follow/companies{fields}")
    public Companies getSuggestedCompanies(@PathParam(value="fields") String var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/suggestions/job-suggestions{fields}")
    public JobSuggestions getSuggestedJobs(@PathParam(value="fields") String var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/~/following/companies{fields}")
    public Companies getFollowedCompanies(@PathParam(value="fields") String var1);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/~/following/companies")
    public void followCompany(Company var1);

    @DELETE
    @Path(value="/~/following/companies/id={company-id}")
    public void stopFollowingCompany(@PathParam(value="company-id") long var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/id={person-id}{fields}")
    public Person getPersonById(@PathParam(value="person-id") String var1, @PathParam(value="fields") String var2, @QueryParam(value="secure-urls") Boolean var3);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/id={person-id}/connections{fields}")
    public Connections getConnectionsById(@PathParam(value="person-id") String var1, @PathParam(value="fields") String var2, @QueryParam(value="secure-urls") Boolean var3);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/id={person-id}/network/updates{fields}")
    public Updates getNetworkUpdatesById(@QueryParam(value="scope") String var1, @QueryParam(value="type") Type var2, @QueryParam(value="count") Long var3, @QueryParam(value="start") Long var4, @QueryParam(value="after") Long var5, @QueryParam(value="before") Long var6, @QueryParam(value="show-hidden-members") Boolean var7, @PathParam(value="person-id") String var8, @PathParam(value="fields") String var9, @QueryParam(value="secure-urls") Boolean var10);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/url={public-profile-url}{fields}")
    public Person getPersonByUrl(@PathParam(value="public-profile-url") String var1, @PathParam(value="fields") String var2, @QueryParam(value="secure-urls") Boolean var3);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/url={public-profile-url}/connections{fields}")
    public Connections getConnectionsByUrl(@PathParam(value="public-profile-url") String var1, @PathParam(value="fields") String var2, @QueryParam(value="secure-urls") Boolean var3);
}

