/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.api;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.component.linkedin.api.Eventtype;
import org.apache.camel.component.linkedin.api.Timegranularity;
import org.apache.camel.component.linkedin.api.model.Comments;
import org.apache.camel.component.linkedin.api.model.Companies;
import org.apache.camel.component.linkedin.api.model.Company;
import org.apache.camel.component.linkedin.api.model.CompanyStatistics;
import org.apache.camel.component.linkedin.api.model.HistoricalFollowStatistics;
import org.apache.camel.component.linkedin.api.model.HistoricalStatusUpdateStatistics;
import org.apache.camel.component.linkedin.api.model.IsCompanyShareEnabled;
import org.apache.camel.component.linkedin.api.model.IsLiked;
import org.apache.camel.component.linkedin.api.model.Likes;
import org.apache.camel.component.linkedin.api.model.NumFollowers;
import org.apache.camel.component.linkedin.api.model.Share;
import org.apache.camel.component.linkedin.api.model.UpdateComment;
import org.apache.camel.component.linkedin.api.model.Updates;

public interface CompaniesResource {
    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies{fields}")
    public Companies getCompanies(@PathParam(value="fields") String var1, @QueryParam(value="email-domain") String var2, @QueryParam(value="is-company-admin") Boolean var3);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}{fields}")
    public Company getCompanyById(@PathParam(value="company-id") long var1, @PathParam(value="fields") String var3);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/universal-name={universal-name}{fields}")
    public Company getCompanyByName(@PathParam(value="universal-name") String var1, @PathParam(value="fields") String var2);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/updates{fields}")
    public Updates getCompanyUpdates(@PathParam(value="company-id") long var1, @PathParam(value="fields") String var3, @QueryParam(value="event-type") Eventtype var4, @QueryParam(value="start") Long var5, @QueryParam(value="count") Long var6);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/updates/key={update-key}/update-comments{fields}")
    public Comments getCompanyUpdateComments(@PathParam(value="company-id") long var1, @PathParam(value="update-key") String var3, @PathParam(value="fields") String var4, @QueryParam(value="secure-urls") Boolean var5);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/companies/{company-id}/updates/key={update-key}/update-comments")
    public void addCompanyUpdateComment(@PathParam(value="company-id") long var1, @PathParam(value="update-key") String var3, UpdateComment var4);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/companies/{company-id}/updates/key={update-key}/update-comments-as-company")
    public void addCompanyUpdateCommentAsCompany(@PathParam(value="company-id") long var1, @PathParam(value="update-key") String var3, UpdateComment var4);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/updates/key={update-key}/likes{fields}")
    public Likes getCompanyUpdateLikes(@PathParam(value="company-id") long var1, @PathParam(value="update-key") String var3, @PathParam(value="fields") String var4, @QueryParam(value="secure-urls") Boolean var5);

    @PUT
    @Consumes(value={"application/xml"})
    @Path(value="/companies/{company-id}/updates/key={update-key}/is-liked")
    public void likeCompanyUpdate(@PathParam(value="company-id") long var1, @PathParam(value="update-key") String var3, IsLiked var4);

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/companies/{company-id}/shares")
    public void addShare(@PathParam(value="company-id") long var1, Share var3);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/is-company-share-enabled")
    public IsCompanyShareEnabled isShareEnabled(@PathParam(value="company-id") long var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/relation-to-viewer/is-company-share-enabled")
    public IsCompanyShareEnabled isViewerShareEnabled(@PathParam(value="company-id") long var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/historical-follow-statistics")
    public HistoricalFollowStatistics getHistoricalFollowStatistics(@PathParam(value="company-id") long var1, @QueryParam(value="start-timestamp") Long var3, @QueryParam(value="end-timestamp") Long var4, @QueryParam(value="time-granularity") Timegranularity var5);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/historical-status-update-statistics")
    public HistoricalStatusUpdateStatistics getHistoricalStatusUpdateStatistics(@PathParam(value="company-id") long var1, @QueryParam(value="start-timestamp") Long var3, @QueryParam(value="end-timestamp") Long var4, @QueryParam(value="time-granularity") Timegranularity var5, @QueryParam(value="update-key") String var6);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/company-statistics")
    public CompanyStatistics getStatistics(@PathParam(value="company-id") long var1);

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/companies/{company-id}/num-followers")
    public NumFollowers getNumberOfFollowers(@PathParam(value="company-id") long var1, @QueryParam(value="geos") List<String> var3, @QueryParam(value="companySizes") List<String> var4, @QueryParam(value="jobFunc") List<String> var5, @QueryParam(value="industries") List<String> var6, @QueryParam(value="seniorities") List<String> var7);
}

