/**
 * Created by Apache CXF WadlToJava code generator
**/
package org.apache.camel.component.linkedin.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import java.util.List;
import org.apache.camel.component.linkedin.api.model.Comments;
import org.apache.camel.component.linkedin.api.model.Companies;
import org.apache.camel.component.linkedin.api.model.Company;
import org.apache.camel.component.linkedin.api.model.CompanyStatistics;
import org.apache.camel.component.linkedin.api.model.HistoricalFollowStatistics;
import org.apache.camel.component.linkedin.api.model.HistoricalStatusUpdateStatistics;
import org.apache.camel.component.linkedin.api.model.IsCompanyShareEnabled;
import org.apache.camel.component.linkedin.api.model.IsLiked;
import org.apache.camel.component.linkedin.api.model.Likes;
import org.apache.camel.component.linkedin.api.model.NumFollowers;
import org.apache.camel.component.linkedin.api.model.Share;
import org.apache.camel.component.linkedin.api.model.UpdateComment;
import org.apache.camel.component.linkedin.api.model.Updates;

public interface CompaniesResource {

    @GET
    @Produces("application/xml")
    @Path("/companies{fields}")
    Companies getCompanies(@PathParam("fields") String fields, @QueryParam("email-domain") String email_domain, @QueryParam("is-company-admin") Boolean is_company_admin);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}{fields}")
    Company getCompanyById(@PathParam("company-id") long company_id, @PathParam("fields") String fields);

    @GET
    @Produces("application/xml")
    @Path("/companies/universal-name={universal-name}{fields}")
    Company getCompanyByName(@PathParam("universal-name") String universal_name, @PathParam("fields") String fields);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/updates{fields}")
    Updates getCompanyUpdates(@PathParam("company-id") long company_id, @PathParam("fields") String fields, @QueryParam("event-type") Eventtype event_type, @QueryParam("start") Long start, 
                @QueryParam("count") Long count);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/updates/key={update-key}/update-comments{fields}")
    Comments getCompanyUpdateComments(@PathParam("company-id") long company_id, @PathParam("update-key") String update_key, @PathParam("fields") String fields, @QueryParam("secure-urls") Boolean secure_urls);

    @POST
    @Consumes("application/xml")
    @Path("/companies/{company-id}/updates/key={update-key}/update-comments")
    void addCompanyUpdateComment(@PathParam("company-id") long company_id, @PathParam("update-key") String update_key, UpdateComment updatecomment);

    @POST
    @Consumes("application/xml")
    @Path("/companies/{company-id}/updates/key={update-key}/update-comments-as-company")
    void addCompanyUpdateCommentAsCompany(@PathParam("company-id") long company_id, @PathParam("update-key") String update_key, UpdateComment updatecomment);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/updates/key={update-key}/likes{fields}")
    Likes getCompanyUpdateLikes(@PathParam("company-id") long company_id, @PathParam("update-key") String update_key, @PathParam("fields") String fields, @QueryParam("secure-urls") Boolean secure_urls);

    @PUT
    @Consumes("application/xml")
    @Path("/companies/{company-id}/updates/key={update-key}/is-liked")
    void likeCompanyUpdate(@PathParam("company-id") long company_id, @PathParam("update-key") String update_key, IsLiked isliked);

    @POST
    @Consumes("application/xml")
    @Path("/companies/{company-id}/shares")
    void addShare(@PathParam("company-id") long company_id, Share share);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/is-company-share-enabled")
    IsCompanyShareEnabled isShareEnabled(@PathParam("company-id") long company_id);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/relation-to-viewer/is-company-share-enabled")
    IsCompanyShareEnabled isViewerShareEnabled(@PathParam("company-id") long company_id);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/historical-follow-statistics")
    HistoricalFollowStatistics getHistoricalFollowStatistics(@PathParam("company-id") long company_id, @QueryParam("start-timestamp") Long start_timestamp, @QueryParam("end-timestamp") Long end_timestamp, @QueryParam("time-granularity") Timegranularity time_granularity);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/historical-status-update-statistics")
    HistoricalStatusUpdateStatistics getHistoricalStatusUpdateStatistics(@PathParam("company-id") long company_id, @QueryParam("start-timestamp") Long start_timestamp, @QueryParam("end-timestamp") Long end_timestamp, @QueryParam("time-granularity") Timegranularity time_granularity, 
                @QueryParam("update-key") String update_key);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/company-statistics")
    CompanyStatistics getStatistics(@PathParam("company-id") long company_id);

    @GET
    @Produces("application/xml")
    @Path("/companies/{company-id}/num-followers")
    NumFollowers getNumberOfFollowers(@PathParam("company-id") long company_id, @QueryParam("geos") List<String> geos, @QueryParam("companySizes") List<String> companySizes, @QueryParam("jobFunc") List<String> jobFunc, 
                @QueryParam("industries") List<String> industries, @QueryParam("seniorities") List<String> seniorities);

}