/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.InputStream;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.internal.ZeebeService;
import org.apache.camel.component.zeebe.model.DeploymentRequest;
import org.apache.camel.component.zeebe.model.DeploymentResponse;
import org.apache.camel.component.zeebe.model.ProcessDeploymentResponse;
import org.apache.camel.component.zeebe.processor.AbstractBaseProcessor;

public class DeploymentProcessor
extends AbstractBaseProcessor {
    public DeploymentProcessor(ZeebeEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        DeploymentRequest message = null;
        Object body = exchange.getMessage().getBody();
        String headerResourceName = (String)exchange.getMessage().getHeader("CamelZeebeResourceName", String.class);
        if (headerResourceName != null && (body instanceof String || body instanceof byte[] || body instanceof InputStream)) {
            message = new DeploymentRequest();
            message.setName(headerResourceName);
            if (body instanceof String) {
                message.setContent(((String)body).getBytes());
            } else if (body instanceof byte[]) {
                message.setContent((byte[])body);
            } else {
                message.setContent(((InputStream)body).readAllBytes());
            }
        } else if (body instanceof DeploymentRequest) {
            message = (DeploymentRequest)body;
        } else if (body instanceof String) {
            try {
                message = (DeploymentRequest)this.objectMapper.readValue((String)body, DeploymentRequest.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalArgumentException("Cannot convert body to DeploymentRequestMessage", jsonProcessingException);
            }
        } else {
            throw new CamelException("Deployment Resource missing");
        }
        DeploymentResponse resultMessage = null;
        switch (this.endpoint.getOperationName()) {
            case DEPLOY_RESOURCE: {
                resultMessage = this.deployResource(message);
                break;
            }
            default: {
                exchange.setException((Throwable)new IllegalArgumentException("Unknown Operation!"));
                throw new IllegalArgumentException("Unknown Operation!");
            }
        }
        this.removeHeaders(exchange);
        this.setBody(exchange, resultMessage, this.endpoint.isFormatJSON());
        exchange.getMessage().setHeader("CamelZeebeIsSuccess", (Object)resultMessage.isSuccess());
        if (resultMessage.isSuccess()) {
            if (resultMessage instanceof ProcessDeploymentResponse) {
                exchange.getMessage().setHeader("CamelZeebeResourceName", (Object)((ProcessDeploymentResponse)resultMessage).getResourceName());
                exchange.getMessage().setHeader("CamelZeebeBPMNProcessId", (Object)((ProcessDeploymentResponse)resultMessage).getBpmnProcessId());
                exchange.getMessage().setHeader("CamelZeebeProcessDefinitionKey", (Object)((ProcessDeploymentResponse)resultMessage).getProcessDefinitionKey());
                exchange.getMessage().setHeader("CamelZeebeVersion", (Object)((ProcessDeploymentResponse)resultMessage).getVersion());
            }
        } else {
            exchange.getMessage().setHeader("CamelZeebeErrorMessage", (Object)resultMessage.getErrorMessage());
            exchange.getMessage().setHeader("CamelZeebeErrorCode", (Object)resultMessage.getErrorCode());
        }
    }

    private DeploymentResponse deployResource(DeploymentRequest message) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.deployResource(message);
    }
}

