/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.yammer.ApiRequestor;
import org.apache.camel.component.yammer.ScribeApiRequestor;
import org.apache.camel.component.yammer.YammerEndpoint;
import org.apache.camel.component.yammer.model.User;
import org.apache.camel.support.ScheduledPollConsumer;

public class YammerUserPollingConsumer
extends ScheduledPollConsumer {
    private final YammerEndpoint endpoint;
    private final String apiUrl;
    private ApiRequestor requestor;

    public YammerUserPollingConsumer(YammerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        long delay = endpoint.getConfig().getDelay();
        this.setDelay(delay);
        this.setTimeUnit(TimeUnit.MILLISECONDS);
        this.apiUrl = this.getApiUrl();
    }

    private String getApiUrl() throws Exception {
        StringBuilder url = new StringBuilder();
        switch (this.endpoint.getConfig().getFunction()) {
            case USERS: {
                url.append("https://www.yammer.com/api/v1/");
                url.append(this.endpoint.getConfig().getFunction().name());
                url.append(".json");
                break;
            }
            case CURRENT: {
                url.append("https://www.yammer.com/api/v1/");
                url.append("users/");
                url.append(this.endpoint.getConfig().getFunction().name());
                url.append(".json");
                break;
            }
            default: {
                throw new Exception(String.format("%s is not a valid Yammer user function type.", this.endpoint.getConfig().getFunction().name()));
            }
        }
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        try {
            String jsonBody = this.requestor.get();
            if (!this.endpoint.getConfig().isUseJson()) {
                ObjectMapper jsonMapper = new ObjectMapper();
                switch (this.endpoint.getConfig().getFunction()) {
                    case USERS: {
                        List users = (List)jsonMapper.readValue(jsonBody, (JavaType)jsonMapper.getTypeFactory().constructCollectionType(List.class, User.class));
                        exchange.getIn().setBody((Object)users);
                        break;
                    }
                    case CURRENT: {
                        User user = (User)jsonMapper.readValue(jsonBody, jsonMapper.getTypeFactory().constructType(User.class));
                        exchange.getIn().setBody((Object)user);
                        break;
                    }
                    default: {
                        throw new Exception(String.format("%s is not a valid Yammer user function type.", this.endpoint.getConfig().getFunction().name()));
                    }
                }
            } else {
                exchange.getIn().setBody((Object)jsonBody);
            }
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.requestor == null) {
            this.requestor = this.endpoint.getConfig().getRequestor();
        }
        if (this.requestor == null) {
            this.requestor = new ScribeApiRequestor(this.apiUrl, this.endpoint.getConfig().getAccessToken());
        }
    }
}

