/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.yammer.ApiRequestor;
import org.apache.camel.component.yammer.ScribeApiRequestor;
import org.apache.camel.component.yammer.YammerEndpoint;
import org.apache.camel.component.yammer.model.Messages;
import org.apache.camel.support.DefaultProducer;

public class YammerMessageProducer
extends DefaultProducer {
    private final YammerEndpoint endpoint;
    private final String apiUrl;
    private ApiRequestor requestor;

    public YammerMessageProducer(YammerEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.apiUrl = this.getApiUrl();
    }

    private String getApiUrl() throws Exception {
        StringBuilder url = new StringBuilder();
        switch (this.endpoint.getConfig().getFunction()) {
            case MESSAGES: {
                url.append("https://www.yammer.com/api/v1/");
                url.append(this.endpoint.getConfig().getFunction().name().toLowerCase());
                url.append(".json");
                break;
            }
            default: {
                throw new Exception(String.format("%s is not a valid Yammer message producer function type.", this.endpoint.getConfig().getFunction().name()));
            }
        }
        return url.toString();
    }

    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getIn().getBody(String.class);
        String jsonBody = this.requestor.post("?body=" + URLEncoder.encode(body, "UTF-8"));
        if (!this.endpoint.getConfig().isUseJson()) {
            ObjectMapper jsonMapper = new ObjectMapper();
            Messages messages = (Messages)jsonMapper.readValue(jsonBody, Messages.class);
            exchange.getIn().setBody((Object)messages);
        } else {
            exchange.getIn().setBody((Object)jsonBody);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.requestor == null) {
            this.requestor = this.endpoint.getConfig().getRequestor();
        }
        if (this.requestor == null) {
            this.requestor = new ScribeApiRequestor(this.apiUrl, this.endpoint.getConfig().getAccessToken());
        }
    }
}

