/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer.scribe;

import org.apache.camel.component.yammer.scribe.JsonTokenExtractor;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.utils.OAuthEncoder;

public class YammerApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://www.yammer.com/dialog/oauth?client_id=%s&redirect_uri=%s";

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JsonTokenExtractor("\"token\":\\s*\"(\\S*?)\"");
    }

    public String getAccessTokenEndpoint() {
        return "https://www.yammer.com/oauth2/access_token.json";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }
}

