/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import org.apache.camel.component.yammer.ApiRequestor;
import org.apache.camel.component.yammer.ScribeApiRequestor;
import org.apache.camel.component.yammer.YammerFunctionType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class YammerConfiguration {
    @UriPath(name="function")
    @Metadata(required="true")
    private YammerFunctionType functionType;
    private String function;
    @UriParam(label="security")
    @Metadata(required="true", secret=true)
    private String consumerKey;
    @UriParam(label="security")
    @Metadata(required="true", secret=true)
    private String consumerSecret;
    @UriParam(label="security")
    @Metadata(required="true")
    private String accessToken;
    @UriParam
    private boolean useJson;
    @UriParam(label="consumer", defaultValue="5000")
    private long delay = 5000L;
    @UriParam(label="consumer", defaultValue="-1")
    private int limit = -1;
    @UriParam(label="consumer", defaultValue="-1")
    private int olderThan = -1;
    @UriParam(label="consumer", defaultValue="-1")
    private int newerThan = -1;
    @UriParam(label="consumer", enums="true,extended")
    private String threaded;
    @UriParam(label="consumer")
    private String userId;
    private ApiRequestor requestor;

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public YammerFunctionType getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(YammerFunctionType functionType) {
        this.functionType = functionType;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public boolean isUseJson() {
        return this.useJson;
    }

    public void setUseJson(boolean useJson) {
        this.useJson = useJson;
    }

    public ApiRequestor getRequestor(String apiUrl) throws Exception {
        if (this.requestor == null) {
            this.requestor = new ScribeApiRequestor(apiUrl, this.getAccessToken());
        }
        return this.requestor;
    }

    public void setRequestor(ApiRequestor requestor) {
        this.requestor = requestor;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOlderThan() {
        return this.olderThan;
    }

    public void setOlderThan(int olderThan) {
        this.olderThan = olderThan;
    }

    public int getNewerThan() {
        return this.newerThan;
    }

    public void setNewerThan(int newerThan) {
        this.newerThan = newerThan;
    }

    public String getThreaded() {
        return this.threaded;
    }

    public void setThreaded(String threaded) {
        this.threaded = threaded;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

