/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.yammer.YammerEndpoint;
import org.apache.camel.component.yammer.YammerFunctionType;
import org.apache.camel.component.yammer.model.Relationships;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.codehaus.jackson.map.ObjectMapper;

public class YammerRelationshipPollingConsumer
extends ScheduledPollConsumer {
    private final YammerEndpoint endpoint;
    private final String apiUrl;

    public YammerRelationshipPollingConsumer(YammerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        long delay = endpoint.getConfig().getDelay();
        this.setDelay(delay);
        this.setTimeUnit(TimeUnit.MILLISECONDS);
        this.apiUrl = this.getApiUrl();
    }

    private String getApiUrl() throws Exception {
        StringBuilder url = new StringBuilder();
        String function = this.endpoint.getConfig().getFunction();
        switch (YammerFunctionType.fromUri(function)) {
            case RELATIONSHIPS: {
                url.append("https://www.yammer.com/api/v1/");
                url.append(function);
                url.append(".json");
                break;
            }
            default: {
                throw new Exception(String.format("%s is not a valid Yammer relationship function type.", function));
            }
        }
        StringBuilder args = new StringBuilder();
        String userId = this.endpoint.getConfig().getUserId();
        if (ObjectHelper.isNotEmpty((Object)userId)) {
            args.append("?user_id=");
            args.append(userId);
            url.append((CharSequence)args);
        }
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        try {
            String jsonBody = this.endpoint.getConfig().getRequestor(this.apiUrl).get();
            if (!this.endpoint.getConfig().isUseJson()) {
                ObjectMapper jsonMapper = new ObjectMapper();
                Relationships relationships = (Relationships)jsonMapper.readValue(jsonBody, Relationships.class);
                exchange.getIn().setBody((Object)relationships);
            } else {
                exchange.getIn().setBody((Object)jsonBody);
            }
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

