/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.yammer.YammerComponent;
import org.apache.camel.component.yammer.YammerConfiguration;
import org.apache.camel.component.yammer.YammerMessagePollingConsumer;
import org.apache.camel.component.yammer.YammerMessageProducer;
import org.apache.camel.component.yammer.YammerRelationshipPollingConsumer;
import org.apache.camel.component.yammer.YammerUserPollingConsumer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="yammer", syntax="yammer:function", consumerClass=YammerMessagePollingConsumer.class, label="social")
public class YammerEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private YammerConfiguration config;

    public YammerEndpoint() {
    }

    public YammerEndpoint(String uri, YammerComponent component) {
        super(uri, (Component)component);
    }

    public YammerEndpoint(String uri, YammerComponent yammerComponent, YammerConfiguration config) {
        this.setConfig(config);
    }

    public Producer createProducer() throws Exception {
        return new YammerMessageProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        switch (this.config.getFunctionType()) {
            case MESSAGES: 
            case ALGO: 
            case FOLLOWING: 
            case MY_FEED: 
            case PRIVATE: 
            case SENT: {
                return new YammerMessagePollingConsumer(this, processor);
            }
            case USERS: 
            case CURRENT: {
                return new YammerUserPollingConsumer(this, processor);
            }
            case RELATIONSHIPS: {
                return new YammerRelationshipPollingConsumer(this, processor);
            }
        }
        throw new Exception(String.format("%s is not a valid Yammer function type.", this.config.getFunction()));
    }

    public boolean isSingleton() {
        return true;
    }

    public YammerConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(YammerConfiguration config) {
        this.config = config;
    }

    protected String createEndpointUri() {
        return String.format("yammer://%s?consumerKey=%s&consumerSecret=%s&accessToken=%s", this.config.getFunction(), this.config.getConsumerKey(), this.config.getConsumerSecret(), this.config.getAccessToken());
    }
}

