/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import org.apache.camel.component.yammer.ApiRequestor;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Verb;

public class ScribeApiRequestor
implements ApiRequestor {
    String apiUrl;
    String apiAccessToken;

    public ScribeApiRequestor(String apiUrl, String apiAccessToken) {
        this.apiUrl = apiUrl;
        this.apiAccessToken = apiAccessToken;
    }

    private String send(Verb verb, String params) throws Exception {
        OAuthRequest request = new OAuthRequest(verb, this.apiUrl + (params != null ? params : ""));
        request.addQuerystringParameter("access_token", this.apiAccessToken);
        Response response = request.send();
        if (response.isSuccessful()) {
            return response.getBody();
        }
        throw new Exception(String.format("Failed to poll %s. Got response code %s and body: %s", this.getApiUrl(), response.getCode(), response.getBody()));
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiAccessToken() {
        return this.apiAccessToken;
    }

    public void setApiAccessToken(String apiAccessToken) {
        this.apiAccessToken = apiAccessToken;
    }

    @Override
    public String get() throws Exception {
        return this.send(Verb.GET, null);
    }

    @Override
    public String post(String params) throws Exception {
        return this.send(Verb.POST, params);
    }
}

