/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class XmppEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/participant";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "xmpp".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "participant", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(22);
        props.add("resource");
        props.add("exchangePattern");
        props.add("createAccount");
        props.add("login");
        props.add("serviceName");
        props.add("participant");
        props.add("room");
        props.add("lazyStartProducer");
        props.add("password");
        props.add("roomPassword");
        props.add("bridgeErrorHandler");
        props.add("port");
        props.add("headerFilterStrategy");
        props.add("testConnectionOnStartup");
        props.add("host");
        props.add("nickname");
        props.add("doc");
        props.add("connectionConfig");
        props.add("exceptionHandler");
        props.add("user");
        props.add("pubsub");
        props.add("connectionPollDelay");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("password");
        secretProps.add("roomPassword");
        secretProps.add("user");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

