/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppConsumer
extends DefaultConsumer
implements PacketListener,
MessageListener,
ChatManagerListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(XmppConsumer.class);
    private final XmppEndpoint endpoint;
    private MultiUserChat muc;
    private Chat privateChat;
    private ChatManager chatManager;
    private XMPPConnection connection;

    public XmppConsumer(XmppEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.connection = this.endpoint.createConnection();
        this.chatManager = this.connection.getChatManager();
        this.chatManager.addChatListener((ChatManagerListener)this);
        if (this.endpoint.getRoom() == null) {
            this.privateChat = this.chatManager.getThreadChat(this.endpoint.getChatId());
            if (this.privateChat != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding listener to existing chat opened to " + this.privateChat.getParticipant());
                }
                this.privateChat.addMessageListener((MessageListener)this);
            } else {
                this.privateChat = this.connection.getChatManager().createChat(this.endpoint.getParticipant(), this.endpoint.getChatId(), (MessageListener)this);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Opening private chat to " + this.privateChat.getParticipant());
                }
            }
        } else {
            ToContainsFilter toFilter = new ToContainsFilter(this.endpoint.getParticipant());
            AndFilter packetFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), toFilter});
            this.connection.addPacketListener((PacketListener)this, (PacketFilter)packetFilter);
            this.muc = new MultiUserChat((Connection)this.connection, this.endpoint.resolveRoom(this.connection));
            this.muc.addMessageListener((PacketListener)this);
            DiscussionHistory history = new DiscussionHistory();
            history.setMaxChars(0);
            this.muc.join(this.endpoint.getNickname(), null, history, (long)SmackConfiguration.getPacketReplyTimeout());
            if (LOG.isInfoEnabled()) {
                LOG.info("Joined room: {} as: {}", (Object)this.muc.getRoom(), (Object)this.endpoint.getNickname());
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.muc != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Leaving room: {}", (Object)this.muc.getRoom());
            }
            this.muc.removeMessageListener((PacketListener)this);
            this.muc.leave();
            this.muc = null;
        }
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    public void chatCreated(Chat chat, boolean createdLocally) {
        if (!createdLocally) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Accepting incoming chat session from " + chat.getParticipant());
            }
            chat.addMessageListener((MessageListener)this);
        }
    }

    public void processPacket(Packet packet) {
        if (packet instanceof Message) {
            this.processMessage(null, (Message)packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Chat chat, Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received XMPP message for {} from {} : {}", new Object[]{this.endpoint.getUser(), this.endpoint.getParticipant(), message.getBody()});
        }
        Exchange exchange = this.endpoint.createExchange(message);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            if (this.muc != null) {
                this.muc.pollMessage();
            }
        }
    }
}

