/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.packet.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppBinding {
    private static final transient Log LOG = LogFactory.getLog(XmppBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public XmppBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public XmppBinding(HeaderFilterStrategy headerFilterStrategy) {
        ObjectHelper.notNull((Object)headerFilterStrategy, (String)"headerFilterStrategy");
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void populateXmppMessage(Message message, Exchange exchange) {
        message.setBody((String)exchange.getIn().getBody(String.class));
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value;
            String name = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(name, value = entry.getValue(), exchange)) continue;
            if ("subject".equalsIgnoreCase(name)) {
                String subject = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setSubject(subject);
                continue;
            }
            if ("language".equalsIgnoreCase(name)) {
                String language = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setLanguage(language);
                continue;
            }
            try {
                message.setProperty(name, value);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Added property name: " + name + " value: " + value.toString()));
            }
            catch (IllegalArgumentException iae) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Cannot add property " + name + " to XMPP message due: "), (Throwable)iae);
            }
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            message.setProperty("exchangeId", (Object)id);
        }
    }

    public Object extractBodyFromXmpp(Exchange exchange, Message message) {
        return message.getBody();
    }

    public Map<String, Object> extractHeadersFromXmpp(Message xmppMessage, Exchange exchange) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String name : xmppMessage.getPropertyNames()) {
            Object value;
            if (this.headerFilterStrategy.applyFilterToExternalHeaders(name, value = xmppMessage.getProperty(name), exchange)) continue;
            answer.put(name, value);
        }
        return answer;
    }
}

