/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppDirectProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(XmppDirectProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPConnection connection;

    public XmppDirectProducer(XmppEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        block11: {
            try {
                if (this.connection == null) {
                    this.connection = this.endpoint.createConnection();
                }
                if (!this.connection.isConnected()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Reconnecting to: " + XmppEndpoint.getConnectionMessage(this.connection));
                    }
                    this.connection.connect();
                }
            }
            catch (XMPPException e) {
                throw new RuntimeExchangeException("Cannot connect to XMPP Server: " + (this.connection != null ? XmppEndpoint.getConnectionMessage(this.connection) : this.endpoint.getHost()), exchange, (Throwable)e);
            }
            try {
                Object body = exchange.getIn().getBody();
                if (body instanceof Packet) {
                    this.connection.sendPacket((Packet)body);
                    break block11;
                }
                if (body instanceof Packet[]) {
                    Packet[] packets;
                    for (Packet packet : packets = (Packet[])body) {
                        this.connection.sendPacket(packet);
                    }
                    break block11;
                }
                throw new Exception("Body does not contain Packet/Packet[] object(s)");
            }
            catch (XMPPException xmppe) {
                throw new RuntimeExchangeException("Cannot send XMPP direct: from " + this.endpoint.getUser() + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, (Throwable)xmppe);
            }
            catch (Exception e) {
                throw new RuntimeExchangeException("Cannot send XMPP direct: from " + this.endpoint.getUser() + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, (Throwable)e);
            }
        }
    }
}

