/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(XmppComponent.class);
    private final Map<String, XmppEndpoint> endpointCache = new HashMap<String, XmppEndpoint>();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String remainingPath;
        if (this.endpointCache.containsKey(uri)) {
            LOG.debug("Using cached endpoint for URI {}", (Object)URISupport.sanitizeUri((String)uri));
            return (Endpoint)this.endpointCache.get(uri);
        }
        LOG.debug("Creating new endpoint for URI {}", (Object)URISupport.sanitizeUri((String)uri));
        XmppEndpoint endpoint = new XmppEndpoint(uri, this);
        URI u = new URI(uri);
        endpoint.setHost(u.getHost());
        endpoint.setPort(u.getPort());
        if (u.getUserInfo() != null) {
            endpoint.setUser(u.getUserInfo());
        }
        if ((remainingPath = u.getPath()) != null) {
            if (remainingPath.startsWith("/")) {
                remainingPath = remainingPath.substring(1);
            }
            if (remainingPath.length() > 0) {
                endpoint.setParticipant(remainingPath);
            }
        }
        this.endpointCache.put(uri, endpoint);
        return endpoint;
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.endpointCache.values());
        this.endpointCache.clear();
    }
}

