/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;

public class XmppGroupChatProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(XmppGroupChatProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPConnection connection;
    private MultiUserChat chat;
    private String room;

    public XmppGroupChatProducer(XmppEndpoint endpoint) throws XMPPException {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) {
        Message message = this.chat.createMessage();
        message.setTo(this.room);
        message.setFrom(this.endpoint.getUser());
        this.endpoint.getBinding().populateXmppMessage(message, exchange);
        try {
            if (!this.connection.isConnected()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reconnecting to: " + XmppEndpoint.getConnectionMessage(this.connection)));
                }
                this.connection.connect();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending XMPP message: " + message.getBody()));
            }
            this.chat.sendMessage(message);
            this.chat.nextMessage();
        }
        catch (XMPPException e) {
            throw new RuntimeExchangeException("Cannot send XMPP message: " + message, exchange, (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        if (this.connection == null) {
            this.connection = this.endpoint.createConnection();
        }
        if (this.chat == null) {
            this.room = this.endpoint.resolveRoom(this.connection);
            this.chat = new MultiUserChat(this.connection, this.room);
            DiscussionHistory history = new DiscussionHistory();
            history.setMaxChars(0);
            this.chat.join(this.endpoint.getNickname(), null, history, (long)SmackConfiguration.getPacketReplyTimeout());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Joined room: " + this.room + " as: " + this.endpoint.getNickname()));
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.chat != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Leaving room: " + this.room));
            }
            this.chat.leave();
            this.chat = null;
        }
        super.doStop();
    }

    public String getRoom() {
        return this.room;
    }
}

