/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;

public class XmppConsumer
extends DefaultConsumer
implements PacketListener,
MessageListener,
ChatManagerListener {
    private static final transient Log LOG = LogFactory.getLog(XmppConsumer.class);
    private final XmppEndpoint endpoint;
    private MultiUserChat muc;
    private Chat privateChat;
    private ChatManager chatManager;
    private XMPPConnection connection;

    public XmppConsumer(XmppEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.connection = this.endpoint.createConnection();
        this.chatManager = this.connection.getChatManager();
        this.chatManager.addChatListener((ChatManagerListener)this);
        if (this.endpoint.getRoom() == null) {
            this.privateChat = this.chatManager.getThreadChat(this.endpoint.getChatId());
            if (this.privateChat != null) {
                LOG.debug((Object)("Adding listener to existing chat opened to " + this.privateChat.getParticipant()));
                this.privateChat.addMessageListener((MessageListener)this);
            } else {
                this.privateChat = this.connection.getChatManager().createChat(this.endpoint.getParticipant(), this.endpoint.getChatId(), (MessageListener)this);
                LOG.debug((Object)("Opening private chat to " + this.privateChat.getParticipant()));
            }
        } else {
            ToContainsFilter toFilter = new ToContainsFilter(this.endpoint.getParticipant());
            AndFilter packetFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), toFilter});
            this.connection.addPacketListener((PacketListener)this, (PacketFilter)packetFilter);
            this.muc = new MultiUserChat(this.connection, this.endpoint.resolveRoom(this.connection));
            this.muc.addMessageListener((PacketListener)this);
            DiscussionHistory history = new DiscussionHistory();
            history.setMaxChars(0);
            this.muc.join(this.endpoint.getNickname(), null, history, (long)SmackConfiguration.getPacketReplyTimeout());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Joined room: " + this.muc.getRoom() + " as: " + this.endpoint.getNickname()));
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.muc != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Leaving room: " + this.muc.getRoom()));
            }
            this.muc.removeMessageListener((PacketListener)this);
            this.muc.leave();
            this.muc = null;
        }
    }

    public void chatCreated(Chat chat, boolean createdLocally) {
        if (!createdLocally) {
            LOG.debug((Object)("Accepting incoming chat session from " + chat.getParticipant()));
            chat.addMessageListener((MessageListener)this);
        }
    }

    public void processPacket(Packet packet) {
        if (packet instanceof Message) {
            this.processMessage(null, (Message)packet);
        }
    }

    public void processMessage(Chat chat, Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received XMPP message for " + this.endpoint.getUser() + " from " + this.endpoint.getParticipant() + " : " + message.getBody()));
        }
        Exchange exchange = this.endpoint.createExchange(message);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }
}

