/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.component.xmpp.XmppExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppConsumer
extends DefaultConsumer<XmppExchange>
implements PacketListener,
MessageListener {
    private static final transient Log LOG = LogFactory.getLog(XmppConsumer.class);
    private final XmppEndpoint endpoint;
    private MultiUserChat muc;
    private XMPPConnection connection;

    public XmppConsumer(XmppEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.connection = this.endpoint.createConnection();
        if (this.endpoint.getRoom() == null) {
            Chat privateChat = this.connection.getChatManager().createChat(this.endpoint.getParticipant(), (MessageListener)this);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Open private chat to: " + privateChat.getParticipant()));
            }
        } else {
            ToContainsFilter toFilter = new ToContainsFilter(this.endpoint.getParticipant());
            AndFilter packetFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), toFilter});
            this.connection.addPacketListener((PacketListener)this, (PacketFilter)packetFilter);
            this.muc = new MultiUserChat(this.connection, this.endpoint.resolveRoom(this.connection));
            this.muc.addMessageListener((PacketListener)this);
            DiscussionHistory history = new DiscussionHistory();
            history.setMaxChars(0);
            this.muc.join(this.endpoint.getNickname(), null, history, (long)SmackConfiguration.getPacketReplyTimeout());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Joined room: " + this.muc.getRoom() + " as: " + this.endpoint.getNickname()));
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.muc != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Leaving room: " + this.muc.getRoom()));
            }
            this.muc.removeMessageListener((PacketListener)this);
            this.muc.leave();
            this.muc = null;
        }
        if (this.connection != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Disconnecting from: " + XmppEndpoint.getConnectionMessage(this.connection)));
            }
            this.connection.disconnect();
            this.connection = null;
        }
    }

    public void processPacket(Packet packet) {
        if (packet instanceof Message) {
            this.processMessage(null, (Message)packet);
        }
    }

    public void processMessage(Chat chat, Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Recieved XMPP message: " + message.getBody()));
        }
        XmppExchange exchange = this.endpoint.createExchange(message);
        try {
            this.getProcessor().process((Exchange)exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }
}

