/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class XmppPrivateChatProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(XmppPrivateChatProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPConnection connection;
    private final String participant;

    public XmppPrivateChatProducer(XmppEndpoint endpoint, String participant) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.participant = participant;
        ObjectHelper.notEmpty((String)participant, (String)"participant");
    }

    public void process(Exchange exchange) {
        String threadId = exchange.getExchangeId();
        try {
            if (this.connection == null) {
                this.connection = this.endpoint.createConnection();
            }
            if (!this.connection.isConnected()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reconnecting to: " + XmppEndpoint.getConnectionMessage(this.connection)));
                }
                this.connection.connect();
            }
        }
        catch (XMPPException e) {
            throw new RuntimeExchangeException("Cannot connect to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, (Throwable)e);
        }
        ChatManager chatManager = this.connection.getChatManager();
        Chat chat = chatManager.getThreadChat(threadId);
        if (chat == null) {
            chat = chatManager.createChat(this.getParticipant(), threadId, new MessageListener(){

                public void processMessage(Chat chat, Message message) {
                }
            });
        }
        Message message = null;
        try {
            message = new Message();
            message.setTo(this.participant);
            message.setThread(threadId);
            message.setType(Message.Type.normal);
            this.endpoint.getBinding().populateXmppMessage(message, exchange);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending XMPP message: " + message.getBody()));
            }
            chat.sendMessage(message);
        }
        catch (XMPPException e) {
            throw new RuntimeExchangeException("Cannot send XMPP message: " + message + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Disconnecting from: " + XmppEndpoint.getConnectionMessage(this.connection)));
            }
            this.connection.disconnect();
            this.connection = null;
        }
        super.doStop();
    }

    public String getParticipant() {
        return this.participant;
    }
}

