/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.component.xmpp.XmppExchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.jivesoftware.smack.packet.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppBinding {
    private HeaderFilterStrategy headerFilterStrategy;

    public XmppBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public XmppBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void populateXmppMessage(Message message, Exchange exchange) {
        message.setBody((String)exchange.getIn().getBody(String.class));
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(name, value)) continue;
            if ("subject".equalsIgnoreCase(name)) {
                String subject = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setSubject(subject);
                continue;
            }
            if ("language".equalsIgnoreCase(name)) {
                String language = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setLanguage(language);
                continue;
            }
            message.setProperty(name, value);
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            message.setProperty("exchangeId", (Object)id);
        }
    }

    public Object extractBodyFromXmpp(XmppExchange exchange, Message message) {
        return message.getBody();
    }

    public Map<String, Object> extractHeadersFromXmpp(Message xmppMessage) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String name : xmppMessage.getPropertyNames()) {
            Object value = xmppMessage.getProperty(name);
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, value)) continue;
            answer.put(name, value);
        }
        return answer;
    }
}

