/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.Iterator;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmpp.XmppBinding;
import org.apache.camel.component.xmpp.XmppComponent;
import org.apache.camel.component.xmpp.XmppConsumer;
import org.apache.camel.component.xmpp.XmppExchange;
import org.apache.camel.component.xmpp.XmppGroupChatProducer;
import org.apache.camel.component.xmpp.XmppPrivateChatProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.MultiUserChat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppEndpoint
extends DefaultEndpoint<XmppExchange> {
    private static final transient Log LOG = LogFactory.getLog(XmppEndpoint.class);
    private XmppBinding binding;
    private String host;
    private int port;
    private String user;
    private String password;
    private String resource = "Camel";
    private boolean login = true;
    private boolean createAccount;
    private String room;
    private String participant;
    private String nickname;
    private String serviceName;

    public XmppEndpoint(String uri, XmppComponent component) {
        super(uri, (Component)component);
        this.binding = new XmppBinding(component.getHeaderFilterStrategy());
    }

    public XmppEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer<XmppExchange> createProducer() throws Exception {
        if (this.room != null) {
            return this.createGroupChatProducer();
        }
        if (this.participant == null) {
            throw new IllegalArgumentException("No room or participant configured on this endpoint: " + (Object)((Object)this));
        }
        return this.createPrivateChatProducer(this.participant);
    }

    public Producer<XmppExchange> createGroupChatProducer() throws Exception {
        return new XmppGroupChatProducer(this);
    }

    public Producer<XmppExchange> createPrivateChatProducer(String participant) throws Exception {
        return new XmppPrivateChatProducer(this, participant);
    }

    public Consumer<XmppExchange> createConsumer(Processor processor) throws Exception {
        return new XmppConsumer(this, processor);
    }

    public XmppExchange createExchange(ExchangePattern pattern) {
        return new XmppExchange(this.getCamelContext(), pattern, this.getBinding());
    }

    public XmppExchange createExchange(Message message) {
        return new XmppExchange(this.getCamelContext(), this.getExchangePattern(), this.getBinding(), message);
    }

    public boolean isSingleton() {
        return true;
    }

    public XMPPConnection createConnection() throws XMPPException {
        XMPPConnection connection = this.port > 0 ? (this.getServiceName() == null ? new XMPPConnection(new ConnectionConfiguration(this.host, this.port)) : new XMPPConnection(new ConnectionConfiguration(this.host, this.port, this.getServiceName()))) : new XMPPConnection(this.host);
        connection.connect();
        if (this.login && !connection.isAuthenticated()) {
            if (this.user != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Logging in to XMPP as user: " + this.user + " on connection: " + XmppEndpoint.getConnectionMessage(connection)));
                }
                if (this.password == null) {
                    LOG.warn((Object)("No password configured for user: " + this.user + " on connection: " + XmppEndpoint.getConnectionMessage(connection)));
                }
                if (this.createAccount) {
                    AccountManager accountManager = new AccountManager(connection);
                    accountManager.createAccount(this.user, this.password);
                }
                if (this.resource != null) {
                    connection.login(this.user, this.password, this.resource);
                } else {
                    connection.login(this.user, this.password);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Logging in anonymously to XMPP on connection: " + XmppEndpoint.getConnectionMessage(connection)));
                }
                connection.loginAnonymously();
            }
        }
        return connection;
    }

    public String resolveRoom(XMPPConnection connection) throws XMPPException {
        ObjectHelper.notEmpty((String)this.room, (String)"room");
        if (this.room.indexOf(64, 0) != -1) {
            return this.room;
        }
        Iterator iterator = MultiUserChat.getServiceNames((XMPPConnection)connection).iterator();
        if (!iterator.hasNext()) {
            throw new XMPPException("Cannot find Multi User Chat service on connection: " + XmppEndpoint.getConnectionMessage(connection));
        }
        String chatServer = (String)iterator.next();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Detected chat server: " + chatServer));
        }
        return this.room + "@" + chatServer;
    }

    public static String getConnectionMessage(XMPPConnection connetion) {
        return connetion.getHost() + ":" + connetion.getPort() + "/" + connetion.getServiceName();
    }

    public XmppBinding getBinding() {
        if (this.binding == null) {
            this.binding = new XmppBinding();
        }
        return this.binding;
    }

    public void setBinding(XmppBinding binding) {
        this.binding = binding;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isCreateAccount() {
        return this.createAccount;
    }

    public void setCreateAccount(boolean createAccount) {
        this.createAccount = createAccount;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    public String getNickname() {
        return this.nickname != null ? this.nickname : this.getUser();
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

