/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.io;

import java.io.InputStream;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StartupStep;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.RoutesBuilderLoaderSupport;
import org.apache.camel.xml.in.ModelParser;

@ManagedResource(description="Managed XML RoutesBuilderLoader")
@RoutesLoader(value="xml")
public class XmlRoutesBuilderLoader
extends RoutesBuilderLoaderSupport {
    public static final String EXTENSION = "xml";
    public static final String NAMESPACE = "http://camel.apache.org/schema/spring";
    private StartupStepRecorder recorder;

    protected void doBuild() throws Exception {
        super.doBuild();
        this.recorder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getStartupStepRecorder();
    }

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return EXTENSION;
    }

    public RoutesBuilder loadRoutesBuilder(final Resource resource) throws Exception {
        return new RouteBuilder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void configure() throws Exception {
                StartupStep step = XmlRoutesBuilderLoader.this.recorder != null ? XmlRoutesBuilderLoader.this.recorder.beginStep(XmlRoutesBuilderLoader.class, resource.getLocation(), "Loading and Parsing XML routes") : null;
                try {
                    try (InputStream is = resource.getInputStream();){
                        new ModelParser(is, XmlRoutesBuilderLoader.NAMESPACE).parseRouteTemplatesDefinition().ifPresent(arg_0 -> (this).setRouteTemplateCollection(arg_0));
                    }
                    is = resource.getInputStream();
                    var3_3 = null;
                    try {
                        new ModelParser(is, XmlRoutesBuilderLoader.NAMESPACE).parseRestsDefinition().ifPresent(arg_0 -> (this).setRestCollection(arg_0));
                    }
                    catch (Throwable throwable) {
                        var3_3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (var3_3 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    var3_3.addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    is = resource.getInputStream();
                    var3_3 = null;
                    try {
                        new ModelParser(is, XmlRoutesBuilderLoader.NAMESPACE).parseRoutesDefinition().ifPresent(arg_0 -> (this).setRouteCollection(arg_0));
                    }
                    catch (Throwable throwable) {
                        var3_3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (var3_3 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    var3_3.addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                finally {
                    if (XmlRoutesBuilderLoader.this.recorder != null) {
                        XmlRoutesBuilderLoader.this.recorder.endStep(step);
                    }
                }
            }
        };
    }
}

