/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xj;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.Expression;
import org.apache.camel.component.xj.JsonXmlStreamReader;
import org.apache.camel.component.xslt.SourceHandlerFactory;

public class JsonSourceHandlerFactoryImpl
implements SourceHandlerFactory {
    private final JsonFactory jsonFactory;
    private boolean isFailOnNullBody = true;

    public JsonSourceHandlerFactoryImpl(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public boolean isFailOnNullBody() {
        return this.isFailOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.isFailOnNullBody = failOnNullBody;
    }

    public Source getSource(Exchange exchange, Expression source) throws Exception {
        String bodyAsString;
        Object body = source != null ? source.evaluate(exchange, Object.class) : exchange.getMessage().getBody();
        JsonParser jsonParser = null;
        if (body instanceof File) {
            jsonParser = this.jsonFactory.createParser((File)body);
        } else if (body instanceof InputStream) {
            jsonParser = this.jsonFactory.createParser((InputStream)body);
        } else if (body instanceof Reader) {
            jsonParser = this.jsonFactory.createParser((Reader)body);
        } else if (body instanceof byte[]) {
            jsonParser = this.jsonFactory.createParser((byte[])body);
        } else if (body instanceof String) {
            jsonParser = this.jsonFactory.createParser((String)body);
        }
        if (jsonParser == null && (bodyAsString = (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange, body)) != null) {
            jsonParser = this.jsonFactory.createParser(bodyAsString);
        }
        if (jsonParser == null) {
            if (this.isFailOnNullBody()) {
                throw new ExpectedBodyTypeException(exchange, Source.class);
            }
            jsonParser = this.jsonFactory.createParser("{}");
        }
        JsonXmlStreamReader xmlStreamReader = new JsonXmlStreamReader(jsonParser);
        return new StAXSource(xmlStreamReader);
    }
}

