/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import java.util.List;
import java.util.Objects;
import org.apache.camel.component.wordpress.api.model.Comment;
import org.apache.camel.component.wordpress.api.model.CommentSearchCriteria;
import org.apache.camel.component.wordpress.api.model.Context;
import org.apache.camel.component.wordpress.api.service.WordpressServiceComments;
import org.apache.camel.component.wordpress.api.service.impl.AbstractWordpressCrudServiceAdapter;
import org.apache.camel.component.wordpress.api.service.spi.CommentsSPI;

public class WordpressServiceCommentsAdapter
extends AbstractWordpressCrudServiceAdapter<CommentsSPI, Comment, CommentSearchCriteria>
implements WordpressServiceComments {
    public WordpressServiceCommentsAdapter(String wordpressUrl, String apiVersion) {
        super(wordpressUrl, apiVersion);
    }

    @Override
    protected Class<CommentsSPI> getSpiType() {
        return CommentsSPI.class;
    }

    @Override
    public List<Comment> list(CommentSearchCriteria c) {
        Objects.requireNonNull(c, "The search criteria must be defined");
        return ((CommentsSPI)this.getSpi()).list(this.getApiVersion(), c.getContext(), c.getPage(), c.getPerPage(), c.getSearch(), c.getAfter(), c.getAuthor(), c.getAuthorExclude(), c.getAuthorEmail(), c.getBefore(), c.getExclude(), c.getInclude(), c.getKarma(), c.getOffset(), c.getOrder(), c.getOrderBy(), c.getParent(), c.getParentExclude(), c.getPost(), c.getStatus(), c.getType());
    }

    @Override
    protected Comment doCreate(Comment object) {
        return ((CommentsSPI)this.getSpi()).create(this.getApiVersion(), object);
    }

    @Override
    protected Comment doDelete(Integer id) {
        return ((CommentsSPI)this.getSpi()).delete(this.getApiVersion(), id, false);
    }

    @Override
    protected Comment doUpdate(Integer id, Comment object) {
        return ((CommentsSPI)this.getSpi()).update(this.getApiVersion(), id, object);
    }

    @Override
    protected Comment doRetrieve(Integer entityID, Context context) {
        return ((CommentsSPI)this.getSpi()).retrieve(this.getApiVersion(), entityID, context);
    }
}

