/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import java.util.List;
import java.util.Objects;
import org.apache.camel.component.wordpress.api.model.Context;
import org.apache.camel.component.wordpress.api.model.DeletedModel;
import org.apache.camel.component.wordpress.api.model.Post;
import org.apache.camel.component.wordpress.api.model.PostSearchCriteria;
import org.apache.camel.component.wordpress.api.service.WordpressServicePosts;
import org.apache.camel.component.wordpress.api.service.impl.AbstractWordpressCrudServiceAdapter;
import org.apache.camel.component.wordpress.api.service.spi.PostsSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordpressServicePostsAdapter
extends AbstractWordpressCrudServiceAdapter<PostsSPI, Post, PostSearchCriteria>
implements WordpressServicePosts {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordpressServicePostsAdapter.class);

    public WordpressServicePostsAdapter(String wordpressUrl, String apiVersion) {
        super(wordpressUrl, apiVersion);
    }

    @Override
    protected Class<PostsSPI> getSpiType() {
        return PostsSPI.class;
    }

    @Override
    public List<Post> list(PostSearchCriteria criteria) {
        LOGGER.debug("Calling list posts: searchCriteria {}", (Object)criteria);
        Objects.requireNonNull(criteria, "Please provide a search criteria");
        return ((PostsSPI)this.getSpi()).list(this.getApiVersion(), criteria.getContext(), criteria.getPage(), criteria.getPerPage(), criteria.getSearch(), criteria.getAfter(), criteria.getAuthor(), criteria.getAuthorExclude(), criteria.getBefore(), criteria.getExclude(), criteria.getInclude(), criteria.getOffset(), criteria.getOrder(), criteria.getOrderBy(), criteria.getSlug(), criteria.getStatus(), criteria.getCategories(), criteria.getCategoriesExclude(), criteria.getTags(), criteria.getTagsExclude(), criteria.getStick());
    }

    @Override
    public Post retrieve(Integer postId, Context context, String password) {
        LOGGER.debug("Calling retrievePosts: postId {};  postContext: {}", (Object)postId, (Object)context);
        if (postId <= 0) {
            throw new IllegalArgumentException("Please provide a non zero post id");
        }
        Objects.requireNonNull(context, "Provide a post context");
        return ((PostsSPI)this.getSpi()).retrieve(this.getApiVersion(), postId, context, password);
    }

    @Override
    protected Post doRetrieve(Integer postId, Context context) {
        return this.retrieve(postId, context, "");
    }

    @Override
    public Post retrieve(Integer postId) {
        return this.retrieve(postId, Context.view, "");
    }

    @Override
    protected Post doCreate(Post object) {
        return ((PostsSPI)this.getSpi()).create(this.getApiVersion(), object);
    }

    @Override
    protected Post doDelete(Integer id) {
        return ((PostsSPI)this.getSpi()).delete(this.getApiVersion(), id);
    }

    @Override
    protected DeletedModel<Post> doForceDelete(Integer id) {
        return ((PostsSPI)this.getSpi()).forceDelete(this.getApiVersion(), id);
    }

    @Override
    protected Post doUpdate(Integer id, Post object) {
        return ((PostsSPI)this.getSpi()).update(this.getApiVersion(), id, object);
    }
}

