/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class WordpressEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operation";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "wordpress".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "operation", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "operationDetail", null, false, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(16);
        props.add("basicPropertyBinding");
        props.add("searchCriteria");
        props.add("criteria");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("url");
        props.add("operationDetail");
        props.add("password");
        props.add("lazyStartProducer");
        props.add("apiVersion");
        props.add("bridgeErrorHandler");
        props.add("force");
        props.add("id");
        props.add("operation");
        props.add("user");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

