/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.wasm;

import com.dylibso.chicory.runtime.ExportFunction;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.wasm.WasmModule;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WasmFunction
implements AutoCloseable {
    private final Lock lock = new ReentrantLock();
    private final WasmModule module;
    private final String functionName;
    private final Instance instance;
    private final ExportFunction function;
    private final ExportFunction alloc;
    private final ExportFunction dealloc;

    public WasmFunction(WasmModule module, String functionName) {
        this.module = Objects.requireNonNull(module);
        this.functionName = Objects.requireNonNull(functionName);
        this.instance = Instance.builder((WasmModule)this.module).build();
        this.function = this.instance.export(this.functionName);
        this.alloc = this.instance.export("alloc");
        this.dealloc = this.instance.export("dealloc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] run(byte[] in) throws Exception {
        Objects.requireNonNull(in);
        int inPtr = -1;
        int inSize = in.length;
        int outPtr = -1;
        int outSize = 0;
        this.lock.lock();
        try {
            byte[] byArray;
            block10: {
                try {
                    inPtr = (int)this.alloc.apply(new long[]{inSize})[0];
                    this.instance.memory().write(inPtr, in);
                    long[] results = this.function.apply(new long[]{inPtr, inSize});
                    long ptrAndSize = results[0];
                    outPtr = (int)(ptrAndSize >> 32);
                    outSize = (int)ptrAndSize;
                    if (WasmFunction.isError(outSize)) {
                        int errSize = WasmFunction.errSize(outSize);
                        String errData = this.instance.memory().readString(outPtr, errSize);
                        throw new RuntimeException(errData);
                    }
                    byArray = this.instance.memory().readBytes(outPtr, outSize);
                    if (inPtr == -1) break block10;
                }
                catch (Throwable throwable) {
                    if (inPtr != -1) {
                        this.dealloc.apply(new long[]{inPtr, inSize});
                    }
                    if (outPtr != -1) {
                        this.dealloc.apply(new long[]{outPtr, outSize});
                    }
                    throw throwable;
                }
                this.dealloc.apply(new long[]{inPtr, inSize});
            }
            if (outPtr != -1) {
                this.dealloc.apply(new long[]{outPtr, outSize});
            }
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
    }

    private static boolean isError(int number) {
        return (number & Integer.MIN_VALUE) != 0;
    }

    private static int errSize(int number) {
        return number & Integer.MAX_VALUE;
    }
}

