/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.wal.EntryInfo;
import org.apache.camel.component.wal.Header;
import org.apache.camel.component.wal.IOUtil;
import org.apache.camel.component.wal.LogEntry;
import org.apache.camel.component.wal.LogSupervisor;
import org.apache.camel.component.wal.PersistedLogEntry;
import org.apache.camel.component.wal.TransactionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogWriter
implements AutoCloseable {
    public static final int DEFAULT_CAPACITY = 524288;
    private static final Logger LOG = LoggerFactory.getLogger(LogWriter.class);
    private final FileChannel fileChannel;
    private final LogSupervisor flushPolicy;
    private final TransactionLog transactionLog;
    private long startOfRecords;

    public LogWriter(File logFile, LogSupervisor logSupervisor) throws IOException {
        this(logFile, logSupervisor, 524288);
    }

    LogWriter(File logFile, LogSupervisor logSupervisor, int maxRecordCount) throws IOException {
        this.fileChannel = FileChannel.open(logFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        Header header = Header.WA_DEFAULT_V1;
        this.writeHeader(header);
        this.flushPolicy = logSupervisor;
        this.transactionLog = new TransactionLog(maxRecordCount);
        this.flushPolicy.start(this::tryFlush);
    }

    void flush() throws IOException {
        this.fileChannel.force(true);
    }

    private synchronized void tryFlush() {
        try {
            this.flush();
        }
        catch (IOException e) {
            LOG.error("Unable to save record: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void reset() throws IOException {
        this.fileChannel.truncate(this.startOfRecords);
        this.fileChannel.position(this.startOfRecords);
    }

    @Override
    public void close() {
        try {
            this.flushPolicy.stop();
            this.flush();
            this.fileChannel.close();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void writeHeader(Header header) throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(Header.BYTES);
        headerBuffer.put(header.getFormatName().getBytes());
        headerBuffer.putInt(header.getFileVersion());
        IOUtil.write(this.fileChannel, headerBuffer);
        this.startOfRecords = this.fileChannel.position();
    }

    public EntryInfo.CachedEntryInfo append(LogEntry entry) throws IOException {
        TransactionLog.LayerInfo layerInfo = this.transactionLog.add(entry);
        if (layerInfo.getLayer() == 0) {
            return this.persist(layerInfo, entry);
        }
        if (layerInfo.isRollingOver()) {
            this.reset();
        }
        LOG.trace("Writing at position {}", (Object)this.fileChannel.position());
        EntryInfo.CachedEntryInfo spear = this.persist(layerInfo, entry);
        List collect = this.transactionLog.stream().filter(c -> c != null && c.layerInfo.getLayer() != this.transactionLog.currentLayer()).map(e -> this.tryPersist(layerInfo, e.logEntry)).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            EntryInfo lastOnLayer = (EntryInfo)collect.get(0);
            LOG.trace("Current pos is: {}", (Object)this.fileChannel.position());
            LOG.trace("Next pos should be: {}", (Object)lastOnLayer.getPosition());
            this.fileChannel.position(lastOnLayer.getPosition());
            LOG.trace("Current pos now is: {}", (Object)this.fileChannel.position());
        }
        return spear;
    }

    private void persist(TransactionLog.LayerInfo layerInfo, LogEntry entry, long position) throws IOException {
        long size;
        ByteBuffer updateBuffer = ByteBuffer.allocate(entry.size());
        IOUtil.serialize(updateBuffer, entry);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Position: {} for record {} with key {}", new Object[]{position, layerInfo, new String(entry.getKey())});
        }
        if ((size = IOUtil.write(this.fileChannel, updateBuffer, position)) == 0L) {
            LOG.warn("No bytes written for the given record!");
        }
    }

    private EntryInfo.CachedEntryInfo persist(TransactionLog.LayerInfo layerInfo, LogEntry entry) throws IOException {
        byte[] key = entry.getKey();
        byte[] value = entry.getValue();
        ByteBuffer writeBuffer = ByteBuffer.allocate(LogEntry.size(key, value));
        IOUtil.serialize(writeBuffer, entry);
        long recordPosition = this.fileChannel.position();
        IOUtil.write(this.fileChannel, writeBuffer);
        return EntryInfo.createForCached(recordPosition, layerInfo);
    }

    private EntryInfo tryPersist(TransactionLog.LayerInfo layerInfo, LogEntry entry) {
        try {
            return this.persist(layerInfo, entry);
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void updateState(EntryInfo.CachedEntryInfo entryInfo, LogEntry.EntryState state) throws IOException {
        TransactionLog.LayerInfo layerInfo = entryInfo.getLayerInfo();
        assert (layerInfo != null);
        LogEntry logEntry = this.transactionLog.update(layerInfo, state);
        if (logEntry != null) {
            this.persist(layerInfo, logEntry, entryInfo.getPosition());
        }
    }

    public void updateState(PersistedLogEntry entry, LogEntry.EntryState state) throws IOException {
        long size;
        ByteBuffer updateBuffer = ByteBuffer.allocate(entry.size());
        IOUtil.serialize(updateBuffer, state.getCode(), entry.getKeyMetadata(), entry.getKey(), entry.getValueMetadata(), entry.getValue());
        EntryInfo entryInfo = entry.getEntryInfo();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Position: {} with key {}", (Object)entryInfo.getPosition(), (Object)new String(entry.getKey()));
        }
        if ((size = IOUtil.write(this.fileChannel, updateBuffer, entryInfo.getPosition())) == 0L) {
            LOG.warn("No bytes written for the given record!");
        }
    }
}

