/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxConsumer.class);
    private final VertxEndpoint endpoint;
    private transient MessageConsumer messageConsumer;
    private Handler<Message<Object>> handler = this::onEventBusEvent;

    public VertxConsumer(VertxEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void onEventBusEvent(final Message event) {
        LOG.debug("onEvent {}", (Object)event);
        final boolean reply = event.replyAddress() != null;
        final Exchange exchange = this.createExchange(true);
        exchange.setPattern(reply ? ExchangePattern.InOut : ExchangePattern.InOnly);
        exchange.getIn().setBody(event.body());
        try {
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    Object body;
                    if (reply && (body = exchange.getMessage().getBody()) != null) {
                        LOG.debug("Sending reply to: {} with body: {}", (Object)event.replyAddress(), body);
                        event.reply(body);
                    }
                }
            });
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing Vertx event: " + event, (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering EventBus handler on address {}", (Object)this.endpoint.getAddress());
        }
        if (this.endpoint.getEventBus() != null) {
            this.messageConsumer = this.endpoint.getEventBus().consumer(this.endpoint.getAddress(), this.handler);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unregistering EventBus handler on address {}", (Object)this.endpoint.getAddress());
        }
        try {
            if (this.messageConsumer != null && this.messageConsumer.isRegistered()) {
                this.messageConsumer.unregister();
                this.messageConsumer = null;
            }
        }
        catch (IllegalStateException e) {
            LOG.warn("EventBus already stopped on address {}", (Object)this.endpoint.getAddress());
        }
        super.doStop();
    }
}

