/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxBuilder;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="vertx")
public class VertxComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(VertxComponent.class);
    private volatile boolean createdVertx;
    @Metadata(label="advanced")
    private VertxBuilder vertxFactory;
    @Metadata(autowired=true)
    private Vertx vertx;
    @Metadata
    private String host;
    @Metadata
    private int port;
    @Metadata(defaultValue="60")
    private int timeout = 60;
    @Metadata
    private VertxOptions vertxOptions;

    public VertxComponent() {
    }

    public VertxComponent(CamelContext context) {
        super(context);
    }

    public VertxBuilder getVertxFactory() {
        return this.vertxFactory;
    }

    public void setVertxFactory(VertxBuilder vertxFactory) {
        this.vertxFactory = vertxFactory;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public VertxOptions getVertxOptions() {
        return this.vertxOptions;
    }

    public void setVertxOptions(VertxOptions vertxOptions) {
        this.vertxOptions = vertxOptions;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        VertxEndpoint endpoint = new VertxEndpoint(uri, this, remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.vertx == null) {
            boolean clustered = false;
            if (this.vertxOptions == null) {
                this.vertxOptions = new VertxOptions();
                if (ObjectHelper.isNotEmpty((String)this.host)) {
                    this.vertxOptions.getEventBusOptions().setHost(this.host);
                    clustered = true;
                }
                if (this.port > 0) {
                    this.vertxOptions.getEventBusOptions().setPort(this.port);
                    clustered = true;
                }
            }
            if (this.vertxFactory == null) {
                this.vertxFactory = new VertxBuilder(this.vertxOptions);
            }
            this.createdVertx = true;
            CountDownLatch latch = new CountDownLatch(1);
            if (clustered) {
                LOG.info("Creating Clustered Vertx {}:{}", (Object)this.vertxOptions.getEventBusOptions().getHost(), (Object)this.vertxOptions.getEventBusOptions().getPort());
                this.vertxFactory.clusteredVertx(event -> {
                    if (event.cause() != null) {
                        LOG.warn("Error creating Clustered Vertx {}:{} due {}", new Object[]{this.host, this.port, event.cause().getMessage(), event.cause()});
                    } else if (event.succeeded()) {
                        this.vertx = (Vertx)event.result();
                        LOG.info("EventBus is ready: {}", (Object)this.vertx);
                    }
                    latch.countDown();
                });
            } else {
                LOG.info("Creating Non-Clustered Vertx");
                this.vertx = this.vertxFactory.init().vertx();
                LOG.info("EventBus is ready: {}", (Object)this.vertx);
                latch.countDown();
            }
            if (latch.getCount() > 0L) {
                LOG.info("Waiting for EventBus to be ready using {} sec as timeout", (Object)this.timeout);
                latch.await(this.timeout, TimeUnit.SECONDS);
            }
        } else {
            LOG.debug("Using Vertx instance set on the component level.");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.createdVertx && this.vertx != null) {
            LOG.info("Stopping Vertx {}", (Object)this.vertx);
            this.vertx.close();
        }
    }
}

