/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.Message;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class VertxProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxProducer.class);

    public VertxProducer(VertxEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public VertxEndpoint getEndpoint() {
        return (VertxEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        EventBus eventBus = this.getEndpoint().getEventBus();
        String address = this.getEndpoint().getAddress();
        Message in = exchange.getIn();
        JsonObject jsonObject = (JsonObject)in.getBody(JsonObject.class);
        if (jsonObject != null) {
            LOG.debug("Publishing to: {} with JsonObject: {}", (Object)address, (Object)jsonObject);
            eventBus.publish(address, jsonObject);
            return;
        }
        JsonArray jsonArray = (JsonArray)in.getBody(JsonArray.class);
        if (jsonArray != null) {
            LOG.debug("Publishing to: {} with JsonArray: {}", (Object)address, (Object)jsonArray);
            eventBus.publish(address, jsonArray);
            return;
        }
        String text = (String)in.getBody(String.class);
        if (text != null) {
            LOG.debug("Publishing to: {} with String: {}", (Object)address, (Object)text);
            eventBus.publish(address, new JsonObject(text));
            return;
        }
        throw new InvalidPayloadRuntimeException(exchange, String.class);
    }
}

