/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.vertx.websocket.VertxWebsocketComponent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHelper;
import org.apache.camel.support.DefaultConsumer;

public class VertxWebsocketConsumer
extends DefaultConsumer {
    private final VertxWebsocketEndpoint endpoint;

    public VertxWebsocketConsumer(VertxWebsocketEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.getComponent().connectConsumer(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getComponent().disconnectConsumer(this);
        super.doStop();
    }

    public VertxWebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public VertxWebsocketComponent getComponent() {
        return this.endpoint.getComponent();
    }

    public void onMessage(String connectionKey, Object message, SocketAddress remote, RoutingContext routingContext) {
        Exchange exchange = this.createExchange(true);
        exchange.getMessage().setBody(message);
        this.populateExchangeHeaders(exchange, connectionKey, remote, routingContext);
        AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
        this.getAsyncProcessor().process(exchange, cb);
    }

    public void onException(String connectionKey, Throwable cause, SocketAddress remote, RoutingContext routingContext) {
        if (cause == ConnectionBase.CLOSED_EXCEPTION) {
            return;
        }
        Exchange exchange = this.createExchange(false);
        this.populateExchangeHeaders(exchange, connectionKey, remote, routingContext);
        this.getExceptionHandler().handleException("Error processing exchange", exchange, cause);
        this.releaseExchange(exchange, false);
    }

    protected void populateExchangeHeaders(Exchange exchange, String connectionKey, SocketAddress remote, RoutingContext routingContext) {
        Message message = exchange.getMessage();
        Map headers = message.getHeaders();
        message.setHeader("CamelVertxWebsocket.remoteAddress", (Object)remote);
        message.setHeader("CamelVertxWebsocket.connectionKey", (Object)connectionKey);
        routingContext.queryParams().forEach((name, value) -> VertxWebsocketHelper.appendHeader(headers, name, value));
        routingContext.pathParams().forEach((name, value) -> VertxWebsocketHelper.appendHeader(headers, name, value));
    }
}

