/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import org.apache.camel.component.vertx.websocket.VertxWebsocketConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;

public final class VertxWebsocketHelper {
    private VertxWebsocketHelper() {
    }

    public static int extractPortNumber(String remaining) {
        int index1 = remaining.indexOf(58);
        int index2 = remaining.indexOf(47);
        if (index1 != -1 && index2 != -1) {
            String result = remaining.substring(index1 + 1, index2);
            if (result.isEmpty()) {
                throw new IllegalArgumentException("Unable to resolve port from URI: " + remaining);
            }
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse port: " + result);
            }
        }
        return 0;
    }

    public static String extractHostName(String remaining) {
        int index = remaining.indexOf(58);
        if (index != -1) {
            return remaining.substring(0, index);
        }
        return "0.0.0.0";
    }

    public static String extractPath(String remaining) {
        int index = remaining.indexOf(47);
        if (index != -1) {
            return remaining.substring(index);
        }
        return "/" + remaining;
    }

    public static VertxWebsocketHostKey createHostKey(VertxWebsocketConfiguration configuration) {
        return new VertxWebsocketHostKey(configuration.getHost(), configuration.getPort());
    }
}

