/*
 * TorchServe APIs
 * TorchServe is a flexible and easy to use tool for serving deep learning models
 *
 * The version of the OpenAPI document: 0.12.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.camel.component.torchserve.client.metrics.invoker.auth;

import org.apache.camel.component.torchserve.client.metrics.invoker.Pair;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-11-01T10:44:28.321338089Z[Etc/UTC]", comments = "Generator version: 7.17.0")
public class HttpBearerAuth implements Authentication {
  private final String scheme;
  private Supplier<String> tokenSupplier;

  public HttpBearerAuth(String scheme) {
    this.scheme = upperCaseBearer(scheme);
  }

  /**
   * Gets the token, which together with the scheme, will be sent as the value of the Authorization header.
   *
   * @return The bearer token
   */
  public String getBearerToken() {
    return tokenSupplier.get();
  }

  /**
   * Sets the token, which together with the scheme, will be sent as the value of the Authorization header.
   *
   * @param bearerToken The bearer token to send in the Authorization header
   */
  public void setBearerToken(String bearerToken) {
    this.tokenSupplier = () -> bearerToken;
  }

  /**
   * Sets the supplier of tokens, which together with the scheme, will be sent as the value of the Authorization header.
   *
   * @param tokenSupplier The supplier of bearer tokens to send in the Authorization header
   */
  public void setBearerToken(Supplier<String> tokenSupplier) {
    this.tokenSupplier = tokenSupplier;
  }

  @Override
  public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
    String bearerToken = tokenSupplier != null ? tokenSupplier.get() : null;
    if (bearerToken == null) {
      return;
    }
    headerParams.put("Authorization", (scheme != null ? scheme + " " : "") + bearerToken);
  }

  private static String upperCaseBearer(String scheme) {
    return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
  }
}
