/*
 * TorchServe APIs
 * TorchServe is a flexible and easy to use tool for serving deep learning models
 *
 * The version of the OpenAPI document: 0.12.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.apache.camel.component.torchserve.client.management.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.apache.camel.component.torchserve.client.management.invoker.ApiException;
import org.apache.camel.component.torchserve.client.management.invoker.ApiClient;
import org.apache.camel.component.torchserve.client.management.invoker.BaseApi;
import org.apache.camel.component.torchserve.client.management.invoker.Configuration;
import org.apache.camel.component.torchserve.client.management.invoker.Pair;

import org.apache.camel.component.torchserve.client.management.model.ApiDescription200Response;
import org.apache.camel.component.torchserve.client.management.model.ApiDescription500Response;
import org.apache.camel.component.torchserve.client.management.model.DescribeModel200ResponseInner;
import org.apache.camel.component.torchserve.client.management.model.ListModels200Response;
import org.apache.camel.component.torchserve.client.management.model.Metrics200Response;
import org.apache.camel.component.torchserve.client.management.model.RegisterModel200Response;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-09-19T13:19:14.580363759Z[Etc/UTC]", comments = "Generator version: 7.11.0")
public class DefaultApi extends BaseApi {

  public DefaultApi() {
    super(Configuration.getDefaultApiClient());
  }

  public DefaultApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * 
   * Get openapi description.
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   */
  public ApiDescription200Response apiDescription() throws ApiException {
    return this.apiDescription(Collections.emptyMap());
  }


  /**
   * 
   * Get openapi description.
   * @param additionalHeaders additionalHeaders for this call
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   */
  public ApiDescription200Response apiDescription(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<ApiDescription200Response> localVarReturnType = new TypeReference<ApiDescription200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "OPTIONS",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Get openapi description.
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   * @deprecated
   */
  @Deprecated
  public ApiDescription200Response apiDescription_0() throws ApiException {
    return this.apiDescription_0(Collections.emptyMap());
  }


  /**
   * 
   * Get openapi description.
   * @param additionalHeaders additionalHeaders for this call
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   * @deprecated
   */
  @Deprecated
  public ApiDescription200Response apiDescription_0(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/api-description";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<ApiDescription200Response> localVarReturnType = new TypeReference<ApiDescription200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Provides detailed information about the default version of a model.
   * @param modelName Name of model to describe. (required)
   * @return List&lt;DescribeModel200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DescribeModel200ResponseInner> describeModel(String modelName) throws ApiException {
    return this.describeModel(modelName, Collections.emptyMap());
  }


  /**
   * 
   * Provides detailed information about the default version of a model.
   * @param modelName Name of model to describe. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;DescribeModel200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DescribeModel200ResponseInner> describeModel(String modelName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling describeModel");
    }
    
    // create path and map variables
    String localVarPath = "/models/{model_name}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<List<DescribeModel200ResponseInner>> localVarReturnType = new TypeReference<List<DescribeModel200ResponseInner>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * List registered models in TorchServe.
   * @param limit Use this parameter to specify the maximum number of items to return. When this value is present, TorchServe does not return more than the specified number of items, but it might return fewer. This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100. (optional)
   * @param nextPageToken The token to retrieve the next set of results. TorchServe provides the token when the response from a previous call has more results than the maximum page size. (optional)
   * @return ListModels200Response
   * @throws ApiException if fails to make API call
   */
  public ListModels200Response listModels(Integer limit, String nextPageToken) throws ApiException {
    return this.listModels(limit, nextPageToken, Collections.emptyMap());
  }


  /**
   * 
   * List registered models in TorchServe.
   * @param limit Use this parameter to specify the maximum number of items to return. When this value is present, TorchServe does not return more than the specified number of items, but it might return fewer. This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100. (optional)
   * @param nextPageToken The token to retrieve the next set of results. TorchServe provides the token when the response from a previous call has more results than the maximum page size. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return ListModels200Response
   * @throws ApiException if fails to make API call
   */
  public ListModels200Response listModels(Integer limit, String nextPageToken, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/models";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("next_page_token", nextPageToken));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<ListModels200Response> localVarReturnType = new TypeReference<ListModels200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Get TorchServe application metrics in prometheus format.
   * @param name Names of metrics to filter (optional)
   * @return Metrics200Response
   * @throws ApiException if fails to make API call
   */
  public Metrics200Response metrics(String name) throws ApiException {
    return this.metrics(name, Collections.emptyMap());
  }


  /**
   * 
   * Get TorchServe application metrics in prometheus format.
   * @param name Names of metrics to filter (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return Metrics200Response
   * @throws ApiException if fails to make API call
   */
  public Metrics200Response metrics(String name, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/metrics";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("name[]", name));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "text/plain; version=0.0.4; charset=utf-8", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<Metrics200Response> localVarReturnType = new TypeReference<Metrics200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Register a new model in TorchServe.
   * @param url Model archive download url, support local file or HTTP(s) protocol. For S3, consider use pre-signed url. (required)
   * @param modelName Name of model. This value will override modelName in MANIFEST.json if present. (optional)
   * @param handler Inference handler entry-point. This value will override handler in MANIFEST.json if present. (optional)
   * @param runtime Runtime for the model custom service code. This value will override runtime in MANIFEST.json if present. (optional)
   * @param batchSize Inference batch size, default: 1. (optional)
   * @param maxBatchDelay Maximum delay for batch aggregation, default: 100. (optional)
   * @param responseTimeout Maximum time, in seconds, the TorchServe waits for a response from the model inference code, default: 120. (optional)
   * @param startupTimeout Maximum time, in seconds, the TorchServe waits for the model to startup/initialize, default: 120. (optional)
   * @param initialWorkers Number of initial workers, default: 0. (optional)
   * @param synchronous Decides whether creation of worker synchronous or not, default: false. (optional, default to false)
   * @param s3SseKms Model mar file is S3 SSE KMS(server side encryption) enabled or not, default: false. (optional, default to false)
   * @param body  (optional)
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response registerModel(String url, String modelName, String handler, String runtime, Integer batchSize, Integer maxBatchDelay, Integer responseTimeout, Integer startupTimeout, Integer initialWorkers, Boolean synchronous, Boolean s3SseKms, Object body) throws ApiException {
    return this.registerModel(url, modelName, handler, runtime, batchSize, maxBatchDelay, responseTimeout, startupTimeout, initialWorkers, synchronous, s3SseKms, body, Collections.emptyMap());
  }


  /**
   * 
   * Register a new model in TorchServe.
   * @param url Model archive download url, support local file or HTTP(s) protocol. For S3, consider use pre-signed url. (required)
   * @param modelName Name of model. This value will override modelName in MANIFEST.json if present. (optional)
   * @param handler Inference handler entry-point. This value will override handler in MANIFEST.json if present. (optional)
   * @param runtime Runtime for the model custom service code. This value will override runtime in MANIFEST.json if present. (optional)
   * @param batchSize Inference batch size, default: 1. (optional)
   * @param maxBatchDelay Maximum delay for batch aggregation, default: 100. (optional)
   * @param responseTimeout Maximum time, in seconds, the TorchServe waits for a response from the model inference code, default: 120. (optional)
   * @param startupTimeout Maximum time, in seconds, the TorchServe waits for the model to startup/initialize, default: 120. (optional)
   * @param initialWorkers Number of initial workers, default: 0. (optional)
   * @param synchronous Decides whether creation of worker synchronous or not, default: false. (optional, default to false)
   * @param s3SseKms Model mar file is S3 SSE KMS(server side encryption) enabled or not, default: false. (optional, default to false)
   * @param body  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response registerModel(String url, String modelName, String handler, String runtime, Integer batchSize, Integer maxBatchDelay, Integer responseTimeout, Integer startupTimeout, Integer initialWorkers, Boolean synchronous, Boolean s3SseKms, Object body, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'url' is set
    if (url == null) {
      throw new ApiException(400, "Missing the required parameter 'url' when calling registerModel");
    }
    
    // create path and map variables
    String localVarPath = "/models";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("url", url));
    localVarQueryParams.addAll(apiClient.parameterToPair("model_name", modelName));
    localVarQueryParams.addAll(apiClient.parameterToPair("handler", handler));
    localVarQueryParams.addAll(apiClient.parameterToPair("runtime", runtime));
    localVarQueryParams.addAll(apiClient.parameterToPair("batch_size", batchSize));
    localVarQueryParams.addAll(apiClient.parameterToPair("max_batch_delay", maxBatchDelay));
    localVarQueryParams.addAll(apiClient.parameterToPair("response_timeout", responseTimeout));
    localVarQueryParams.addAll(apiClient.parameterToPair("startup_timeout", startupTimeout));
    localVarQueryParams.addAll(apiClient.parameterToPair("initial_workers", initialWorkers));
    localVarQueryParams.addAll(apiClient.parameterToPair("synchronous", synchronous));
    localVarQueryParams.addAll(apiClient.parameterToPair("s3_sse_kms", s3SseKms));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "text/plain"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Configure number of workers for a default version of a model. This is an asynchronous call by default. Caller need to call describeModel to check if the model workers has been changed.
   * @param modelName Name of model to scale workers. (required)
   * @param minWorker Minimum number of worker processes. (optional)
   * @param maxWorker Maximum number of worker processes. (optional)
   * @param numberGpu Number of GPU worker processes to create. (optional)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response setAutoScale(String modelName, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout) throws ApiException {
    return this.setAutoScale(modelName, minWorker, maxWorker, numberGpu, synchronous, timeout, Collections.emptyMap());
  }


  /**
   * 
   * Configure number of workers for a default version of a model. This is an asynchronous call by default. Caller need to call describeModel to check if the model workers has been changed.
   * @param modelName Name of model to scale workers. (required)
   * @param minWorker Minimum number of worker processes. (optional)
   * @param maxWorker Maximum number of worker processes. (optional)
   * @param numberGpu Number of GPU worker processes to create. (optional)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response setAutoScale(String modelName, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling setAutoScale");
    }
    
    // create path and map variables
    String localVarPath = "/models/{model_name}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("min_worker", minWorker));
    localVarQueryParams.addAll(apiClient.parameterToPair("max_worker", maxWorker));
    localVarQueryParams.addAll(apiClient.parameterToPair("number_gpu", numberGpu));
    localVarQueryParams.addAll(apiClient.parameterToPair("synchronous", synchronous));
    localVarQueryParams.addAll(apiClient.parameterToPair("timeout", timeout));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Set default version of a model
   * @param modelName Name of model whose default version needs to be updated. (required)
   * @param modelVersion Version of model to be set as default version for the model (required)
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response setDefault(String modelName, String modelVersion) throws ApiException {
    return this.setDefault(modelName, modelVersion, Collections.emptyMap());
  }


  /**
   * 
   * Set default version of a model
   * @param modelName Name of model whose default version needs to be updated. (required)
   * @param modelVersion Version of model to be set as default version for the model (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response setDefault(String modelName, String modelVersion, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling setDefault");
    }
    
    // verify the required parameter 'modelVersion' is set
    if (modelVersion == null) {
      throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling setDefault");
    }
    
    // create path and map variables
    String localVarPath = "/models/{model_name}/{model_version}/set-default"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)))
      .replaceAll("\\{" + "model_version" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelVersion)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Unregister the default version of a model from TorchServe if it is the only version available. This is an asynchronous call by default. Caller can call listModels to confirm model is unregistered.
   * @param modelName Name of model to unregister. (required)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response unregisterModel(String modelName, Boolean synchronous, Integer timeout) throws ApiException {
    return this.unregisterModel(modelName, synchronous, timeout, Collections.emptyMap());
  }


  /**
   * 
   * Unregister the default version of a model from TorchServe if it is the only version available. This is an asynchronous call by default. Caller can call listModels to confirm model is unregistered.
   * @param modelName Name of model to unregister. (required)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response unregisterModel(String modelName, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling unregisterModel");
    }
    
    // create path and map variables
    String localVarPath = "/models/{model_name}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("synchronous", synchronous));
    localVarQueryParams.addAll(apiClient.parameterToPair("timeout", timeout));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Provides detailed information about the specified version of a model.If \&quot;all\&quot; is specified as version, returns the details about all the versions of the model.
   * @param modelName Name of model to describe. (required)
   * @param modelVersion Version of model to describe. (required)
   * @return List&lt;DescribeModel200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DescribeModel200ResponseInner> versionDescribeModel(String modelName, String modelVersion) throws ApiException {
    return this.versionDescribeModel(modelName, modelVersion, Collections.emptyMap());
  }


  /**
   * 
   * Provides detailed information about the specified version of a model.If \&quot;all\&quot; is specified as version, returns the details about all the versions of the model.
   * @param modelName Name of model to describe. (required)
   * @param modelVersion Version of model to describe. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;DescribeModel200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DescribeModel200ResponseInner> versionDescribeModel(String modelName, String modelVersion, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling versionDescribeModel");
    }
    
    // verify the required parameter 'modelVersion' is set
    if (modelVersion == null) {
      throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling versionDescribeModel");
    }
    
    // create path and map variables
    String localVarPath = "/models/{model_name}/{model_version}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)))
      .replaceAll("\\{" + "model_version" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelVersion)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<List<DescribeModel200ResponseInner>> localVarReturnType = new TypeReference<List<DescribeModel200ResponseInner>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Configure number of workers for a specified version of a model. This is an asynchronous call by default. Caller need to call describeModel to check if the model workers has been changed.
   * @param modelName Name of model to scale workers. (required)
   * @param modelVersion Version of model to scale workers. (required)
   * @param minWorker Minimum number of worker processes. (optional)
   * @param maxWorker Maximum number of worker processes. (optional)
   * @param numberGpu Number of GPU worker processes to create. (optional)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response versionSetAutoScale(String modelName, String modelVersion, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout) throws ApiException {
    return this.versionSetAutoScale(modelName, modelVersion, minWorker, maxWorker, numberGpu, synchronous, timeout, Collections.emptyMap());
  }


  /**
   * 
   * Configure number of workers for a specified version of a model. This is an asynchronous call by default. Caller need to call describeModel to check if the model workers has been changed.
   * @param modelName Name of model to scale workers. (required)
   * @param modelVersion Version of model to scale workers. (required)
   * @param minWorker Minimum number of worker processes. (optional)
   * @param maxWorker Maximum number of worker processes. (optional)
   * @param numberGpu Number of GPU worker processes to create. (optional)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response versionSetAutoScale(String modelName, String modelVersion, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling versionSetAutoScale");
    }
    
    // verify the required parameter 'modelVersion' is set
    if (modelVersion == null) {
      throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling versionSetAutoScale");
    }
    
    // create path and map variables
    String localVarPath = "/models/{model_name}/{model_version}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)))
      .replaceAll("\\{" + "model_version" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelVersion)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("min_worker", minWorker));
    localVarQueryParams.addAll(apiClient.parameterToPair("max_worker", maxWorker));
    localVarQueryParams.addAll(apiClient.parameterToPair("number_gpu", numberGpu));
    localVarQueryParams.addAll(apiClient.parameterToPair("synchronous", synchronous));
    localVarQueryParams.addAll(apiClient.parameterToPair("timeout", timeout));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Unregister the specified version of a model from TorchServe. This is an asynchronous call by default. Caller can call listModels to confirm model is unregistered
   * @param modelName Name of model to unregister. (required)
   * @param modelVersion Version of model to unregister. (required)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response versionUnregisterModel(String modelName, String modelVersion, Boolean synchronous, Integer timeout) throws ApiException {
    return this.versionUnregisterModel(modelName, modelVersion, synchronous, timeout, Collections.emptyMap());
  }


  /**
   * 
   * Unregister the specified version of a model from TorchServe. This is an asynchronous call by default. Caller can call listModels to confirm model is unregistered
   * @param modelName Name of model to unregister. (required)
   * @param modelVersion Version of model to unregister. (required)
   * @param synchronous Decides whether the call is synchronous or not, default: false. (optional, default to false)
   * @param timeout Waiting up to the specified wait time if necessary for a worker to complete all pending requests. Use 0 to terminate backend worker process immediately. Use -1 for wait infinitely. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return RegisterModel200Response
   * @throws ApiException if fails to make API call
   */
  public RegisterModel200Response versionUnregisterModel(String modelName, String modelVersion, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling versionUnregisterModel");
    }
    
    // verify the required parameter 'modelVersion' is set
    if (modelVersion == null) {
      throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling versionUnregisterModel");
    }
    
    // create path and map variables
    String localVarPath = "/models/{model_name}/{model_version}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)))
      .replaceAll("\\{" + "model_version" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelVersion)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("synchronous", synchronous));
    localVarQueryParams.addAll(apiClient.parameterToPair("timeout", timeout));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
