/*
 * TorchServe APIs
 * TorchServe is a flexible and easy to use tool for serving deep learning models
 *
 * The version of the OpenAPI document: 0.12.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.apache.camel.component.torchserve.client.inference.api;

import com.fasterxml.jackson.core.type.TypeReference;

import org.apache.camel.component.torchserve.client.inference.invoker.ApiException;
import org.apache.camel.component.torchserve.client.inference.invoker.ApiClient;
import org.apache.camel.component.torchserve.client.inference.invoker.BaseApi;
import org.apache.camel.component.torchserve.client.inference.invoker.Configuration;
import org.apache.camel.component.torchserve.client.inference.invoker.Pair;

import org.apache.camel.component.torchserve.client.inference.model.ApiDescription200Response;
import org.apache.camel.component.torchserve.client.inference.model.ApiDescription500Response;
import org.apache.camel.component.torchserve.client.inference.model.Metrics200Response;
import org.apache.camel.component.torchserve.client.inference.model.Ping200Response;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-08T12:06:33.936834819Z[Etc/UTC]", comments = "Generator version: 7.11.0")
public class DefaultApi extends BaseApi {

  public DefaultApi() {
    super(Configuration.getDefaultApiClient());
  }

  public DefaultApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * 
   * Get openapi description.
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   */
  public ApiDescription200Response apiDescription() throws ApiException {
    return this.apiDescription(Collections.emptyMap());
  }


  /**
   * 
   * Get openapi description.
   * @param additionalHeaders additionalHeaders for this call
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   */
  public ApiDescription200Response apiDescription(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<ApiDescription200Response> localVarReturnType = new TypeReference<ApiDescription200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "OPTIONS",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Get openapi description.
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   * @deprecated
   */
  @Deprecated
  public ApiDescription200Response apiDescription_0() throws ApiException {
    return this.apiDescription_0(Collections.emptyMap());
  }


  /**
   * 
   * Get openapi description.
   * @param additionalHeaders additionalHeaders for this call
   * @return ApiDescription200Response
   * @throws ApiException if fails to make API call
   * @deprecated
   */
  @Deprecated
  public ApiDescription200Response apiDescription_0(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/api-description";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<ApiDescription200Response> localVarReturnType = new TypeReference<ApiDescription200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Get TorchServe application metrics in prometheus format.
   * @param name Names of metrics to filter (optional)
   * @return Metrics200Response
   * @throws ApiException if fails to make API call
   */
  public Metrics200Response metrics(String name) throws ApiException {
    return this.metrics(name, Collections.emptyMap());
  }


  /**
   * 
   * Get TorchServe application metrics in prometheus format.
   * @param name Names of metrics to filter (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return Metrics200Response
   * @throws ApiException if fails to make API call
   */
  public Metrics200Response metrics(String name, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/metrics";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("name[]", name));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "text/plain; version=0.0.4; charset=utf-8", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<Metrics200Response> localVarReturnType = new TypeReference<Metrics200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Get TorchServe status.
   * @return Ping200Response
   * @throws ApiException if fails to make API call
   */
  public Ping200Response ping() throws ApiException {
    return this.ping(Collections.emptyMap());
  }


  /**
   * 
   * Get TorchServe status.
   * @param additionalHeaders additionalHeaders for this call
   * @return Ping200Response
   * @throws ApiException if fails to make API call
   */
  public Ping200Response ping(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/ping";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<Ping200Response> localVarReturnType = new TypeReference<Ping200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Predictions entry point to get inference using default model version.
   * @param modelName Name of model. (required)
   * @param body Input data format is defined by each model. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object predictions(String modelName, Object body) throws ApiException {
    return this.predictions(modelName, body, Collections.emptyMap());
  }


  /**
   * 
   * Predictions entry point to get inference using default model version.
   * @param modelName Name of model. (required)
   * @param body Input data format is defined by each model. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object predictions(String modelName, Object body, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling predictions");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling predictions");
    }
    
    // create path and map variables
    String localVarPath = "/v1/models/{model_name}:predict"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Predictions entry point to get inference using default model version.
   * @param modelName Name of model. (required)
   * @param body Input data format is defined by each model. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object predictions_0(String modelName, Object body) throws ApiException {
    return this.predictions_0(modelName, body, Collections.emptyMap());
  }


  /**
   * 
   * Predictions entry point to get inference using default model version.
   * @param modelName Name of model. (required)
   * @param body Input data format is defined by each model. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object predictions_0(String modelName, Object body, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling predictions_0");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling predictions_0");
    }
    
    // create path and map variables
    String localVarPath = "/v2/models/{model_name}/infer"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Predictions entry point to get inference using default model version.
   * @param modelName Name of model. (required)
   * @param body Input data format is defined by each model. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object predictions_1(String modelName, Object body) throws ApiException {
    return this.predictions_1(modelName, body, Collections.emptyMap());
  }


  /**
   * 
   * Predictions entry point to get inference using default model version.
   * @param modelName Name of model. (required)
   * @param body Input data format is defined by each model. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object predictions_1(String modelName, Object body, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling predictions_1");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling predictions_1");
    }
    
    // create path and map variables
    String localVarPath = "/predictions/{model_name}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * 
   * Predictions entry point to get inference using specific model version.
   * @param modelName Name of model. (required)
   * @param modelVersion Name of model version. (required)
   * @param body Input data format is defined by each model. (required)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object versionPredictions(String modelName, String modelVersion, Object body) throws ApiException {
    return this.versionPredictions(modelName, modelVersion, body, Collections.emptyMap());
  }


  /**
   * 
   * Predictions entry point to get inference using specific model version.
   * @param modelName Name of model. (required)
   * @param modelVersion Name of model version. (required)
   * @param body Input data format is defined by each model. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object versionPredictions(String modelName, String modelVersion, Object body, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'modelName' is set
    if (modelName == null) {
      throw new ApiException(400, "Missing the required parameter 'modelName' when calling versionPredictions");
    }
    
    // verify the required parameter 'modelVersion' is set
    if (modelVersion == null) {
      throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling versionPredictions");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling versionPredictions");
    }
    
    // create path and map variables
    String localVarPath = "/predictions/{model_name}/{model_version}"
      .replaceAll("\\{" + "model_name" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelName)))
      .replaceAll("\\{" + "model_version" + "\\}", apiClient.escapeString(apiClient.parameterToString(modelVersion)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "*/*", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
