/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.testcontainers.spring.junit5;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.test.spring.junit5.CamelSpringTestSupport;
import org.apache.camel.test.testcontainers.junit5.ContainerPropertiesFunction;
import org.apache.camel.test.testcontainers.junit5.Containers;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public abstract class ContainerAwareSpringTestSupport
extends CamelSpringTestSupport {
    private List<GenericContainer<?>> containers = new CopyOnWriteArrayList();

    protected void setupResources() throws Exception {
        super.setupResources();
        this.containers.clear();
        this.containers.addAll(this.createContainers());
        Network network = this.containerNetwork();
        long timeout = this.containersStartupTimeout();
        Containers.start(this.containers, (Network)network, (long)timeout);
    }

    protected void cleanupResources() throws Exception {
        super.cleanupResources();
        Containers.stop(this.containers, (long)this.containerShutdownTimeout());
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = context.getPropertiesComponent();
        pc.addPropertiesFunction((PropertiesFunction)new ContainerPropertiesFunction(this.containers));
        return context;
    }

    protected GenericContainer<?> createContainer() {
        return null;
    }

    protected List<GenericContainer<?>> createContainers() {
        GenericContainer<?> container = this.createContainer();
        return container == null ? Collections.emptyList() : Collections.singletonList(container);
    }

    protected long containersStartupTimeout() {
        return TimeUnit.MINUTES.toSeconds(1L);
    }

    protected long containerShutdownTimeout() {
        return TimeUnit.MINUTES.toSeconds(1L);
    }

    protected Network containerNetwork() {
        return null;
    }

    protected GenericContainer<?> getContainer(String containerName) {
        return Containers.lookup(this.containers, (String)containerName);
    }

    protected String getContainerHost(String containerName) {
        return this.getContainer(containerName).getContainerIpAddress();
    }

    protected int getContainerPort(String containerName, int originalPort) {
        return this.getContainer(containerName).getMappedPort(originalPort);
    }
}

