/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import org.apache.camel.test.junit5.util.CamelContextTestHelper;

public class TestExecutionConfiguration {
    private boolean jmx;
    private boolean dumpRouteCoverage = false;
    private String dumpRoute;
    private boolean useAdviceWith = false;
    private boolean createCamelContextPerClass = false;
    private boolean useRouteBuilder = true;
    private boolean autoStartContext = true;

    public boolean isJmxEnabled() {
        return this.jmx;
    }

    public TestExecutionConfiguration withEnableJMX() {
        return this.withJMX(true);
    }

    public TestExecutionConfiguration withDisableJMX() {
        return this.withJMX(false);
    }

    public TestExecutionConfiguration withJMX(boolean enableJMX) {
        this.jmx = enableJMX;
        return this;
    }

    public String getDumpRoute() {
        return this.dumpRoute;
    }

    public TestExecutionConfiguration withDumpRoute(String dumpRoute) {
        this.dumpRoute = dumpRoute;
        return this;
    }

    public boolean isRouteDumpEnabled() {
        String dump = CamelContextTestHelper.getRouteDump(this.getDumpRoute());
        return dump == null || dump.isBlank();
    }

    public boolean isDumpRouteCoverage() {
        return this.dumpRouteCoverage;
    }

    public TestExecutionConfiguration withDumpRouteCoverage(boolean dumpRouteCoverage) {
        this.dumpRouteCoverage = dumpRouteCoverage;
        return this;
    }

    public boolean isRouteCoverageEnabled() {
        return CamelContextTestHelper.isRouteCoverageEnabled(this.isDumpRouteCoverage());
    }

    public boolean isUseAdviceWith() {
        return this.useAdviceWith;
    }

    public TestExecutionConfiguration withUseAdviceWith(boolean useAdviceWith) {
        this.useAdviceWith = useAdviceWith;
        return this;
    }

    public boolean isCreateCamelContextPerClass() {
        return this.createCamelContextPerClass;
    }

    @Deprecated(since="4.7.0")
    protected TestExecutionConfiguration withCreateCamelContextPerClass(boolean createCamelContextPerClass) {
        this.createCamelContextPerClass = createCamelContextPerClass;
        return this;
    }

    public boolean useRouteBuilder() {
        return this.useRouteBuilder;
    }

    public TestExecutionConfiguration withUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
        return this;
    }

    public boolean autoStartContext() {
        return this.autoStartContext;
    }

    @Deprecated(since="4.7.0")
    public TestExecutionConfiguration withAutoStartContext(boolean autoStartContext) {
        this.autoStartContext = autoStartContext;
        return this;
    }
}

