/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.zookeeper.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.zookeeper.services.ZooKeeperLocalContainerService;
import org.apache.camel.test.infra.zookeeper.services.ZooKeeperRemoteService;
import org.apache.camel.test.infra.zookeeper.services.ZooKeeperService;

public final class ZooKeeperServiceFactory {
    private ZooKeeperServiceFactory() {
    }

    public static SimpleTestServiceBuilder<ZooKeeperService> builder() {
        return new SimpleTestServiceBuilder("zookeeper");
    }

    public static ZooKeeperService createService() {
        return (ZooKeeperService)ZooKeeperServiceFactory.builder().addLocalMapping(ZooKeeperLocalContainerService::new).addRemoteMapping(ZooKeeperRemoteService::new).build();
    }

    private static class SingletonZooKeeperService
    extends SingletonService<ZooKeeperService>
    implements ZooKeeperService {
        public SingletonZooKeeperService(ZooKeeperService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String getConnectionString() {
            return ((ZooKeeperService)this.getService()).getConnectionString();
        }
    }
}

